/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.map;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.injectors.MapDecorationInjector;
import earth.terrarium.pastel.items.map.StructureLocatorAsync;
import earth.terrarium.pastel.mixin.accessors.MapStateAccessor;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class ArtisansAtlasState
extends MapItemSavedData {
    private final MapStateAccessor accessor = (MapStateAccessor)((Object)this);
    private Set<BlockPos> targets = new HashSet<BlockPos>();
    private BlockPos displayedCenter;
    private ResourceLocation targetId;
    @Nullable
    private Vec3i displayDelta;
    @Nullable
    private StructureLocatorAsync locator;

    public ArtisansAtlasState(byte scale, boolean locked, ResourceKey<Level> dimension) {
        this(0.0, 0.0, scale, false, false, locked, dimension);
    }

    public ArtisansAtlasState(double centerX, double centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, boolean locked, ResourceKey<Level> dimension) {
        super((int)centerX, (int)centerZ, scale, showIcons, unlimitedTracking, locked, dimension);
        this.displayedCenter = new BlockPos((int)centerX, 0, (int)centerZ);
        this.displayDelta = null;
        this.locator = null;
    }

    public ArtisansAtlasState(double centerX, double centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, boolean locked, ResourceKey<Level> dimension, CompoundTag nbt) {
        this((int)centerX, (int)centerZ, scale, showIcons, unlimitedTracking, locked, dimension);
        this.displayDelta = Vec3i.ZERO;
        this.targetId = nbt.contains("targetId", 8) ? ResourceLocation.parse((String)nbt.getString("targetId")) : null;
        int xDisplay = nbt.contains("displayX", 99) ? nbt.getInt("displayX") : this.displayedCenter.getX();
        int zDisplay = nbt.contains("displayZ", 99) ? nbt.getInt("displayZ") : this.displayedCenter.getZ();
        this.displayedCenter = new BlockPos(xDisplay, 0, zDisplay);
        this.targets = new HashSet<BlockPos>(CodecHelper.fromNbt(BlockPos.CODEC.listOf(), nbt.get("targets"), List.of()));
    }

    @Nullable
    public static Pair<ResourceLocation, StructureStart> locateAnyStructureAtBlock(ServerLevel world, BlockPos pos) {
        Registry registry = world.registryAccess().registry(Registries.STRUCTURE).orElse(null);
        if (registry != null) {
            for (Structure structure : registry.stream().toList()) {
                ResourceLocation id = registry.getKey((Object)structure);
                StructureStart start = world.structureManager().getStructureWithPieceAt(pos, structure);
                if (start == StructureStart.INVALID_START || id == null) continue;
                return new Pair((Object)id, (Object)start);
            }
        }
        return null;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt = super.save(nbt, lookup);
        nbt.putBoolean("isArtisansAtlas", true);
        nbt.putInt("displayX", this.displayedCenter.getX());
        nbt.putInt("displayZ", this.displayedCenter.getZ());
        if (this.targetId != null) {
            nbt.putString("targetId", this.targetId.toString());
        }
        CodecHelper.writeNbt(nbt, "targets", BlockPos.CODEC.listOf(), this.targets.stream().toList());
        return nbt;
    }

    public MapItemSavedData scaled() {
        return ArtisansAtlasState.createFresh((double)this.centerX, (double)this.centerZ, (byte)((byte)Mth.clamp((int)(this.scale + 1), (int)0, (int)4)), (boolean)this.accessor.getTrackingPosition(), (boolean)this.accessor.getUnlimitedTracking(), (ResourceKey)this.dimension);
    }

    public void tickCarriedBy(Player player, ItemStack stack) {
        if (this.displayDelta != null) {
            Level level;
            if (this.locator == null && this.targetId != null && (level = player.level()) instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                this.startLocator(world);
            }
            this.displayDelta = player.blockPosition().subtract((Vec3i)this.displayedCenter);
        } else {
            this.displayedCenter = player.blockPosition();
        }
        this.accessor.getDecorations().clear();
        super.tickCarriedBy(player, stack);
        for (BlockPos target : this.targets) {
            this.addTargetIcon((LevelAccessor)player.level(), target);
        }
    }

    public void addDecoration(Holder<MapDecorationType> type, @Nullable LevelAccessor world, String key, double x, double z, double rotation, @Nullable Component text) {
        int scale = 1 << this.scale;
        float scaledX = (float)(x - (double)this.displayedCenter.getX()) / (float)scale;
        float scaledZ = (float)(z - (double)this.displayedCenter.getZ()) / (float)scale;
        float squaredDistance = scaledX * scaledX + scaledZ * scaledZ;
        byte scaleByte = (byte)Math.clamp(-16.0 * (0.5 * Math.log(squaredDistance) / Math.log(2.0) - 7.0), -100.0, 0.0);
        byte pixelX = (byte)(scaledX * 2.0f + 0.5f);
        byte pixelZ = (byte)(scaledZ * 2.0f + 0.5f);
        byte rotationByte = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
        if (this.dimension == Level.NETHER && world != null) {
            int light = (int)(world.getLevelData().getDayTime() / 10L);
            rotationByte = (byte)(light * light * 34187121 + light * 121 >> 15 & 0xF);
        }
        if (scaledX < -63.0f || scaledZ < -63.0f || scaledX > 63.0f || scaledZ > 63.0f) {
            double borderRotation;
            if (scaledZ >= 63.0f) {
                pixelZ = 127;
                if (scaledX <= -63.0f) {
                    pixelX = -128;
                    borderRotation = -135.0;
                } else if (scaledX >= 63.0f) {
                    pixelX = 127;
                    borderRotation = 135.0;
                } else {
                    borderRotation = 180.0;
                }
            } else if (scaledZ <= -63.0f) {
                pixelZ = -128;
                if (scaledX <= -63.0f) {
                    pixelX = -128;
                    borderRotation = -45.0;
                } else if (scaledX >= 63.0f) {
                    pixelX = 127;
                    borderRotation = 45.0;
                } else {
                    borderRotation = 0.0;
                }
            } else if (scaledX <= -63.0f) {
                pixelX = -128;
                borderRotation = -90.0;
            } else {
                pixelX = 127;
                borderRotation = 90.0;
            }
            if (type.is(MapDecorationTypes.PLAYER)) {
                type = MapDecorationTypes.PLAYER_OFF_MAP;
                rotationByte = 0;
            } else if (type.is(MapDecorationTypes.TARGET_POINT)) {
                rotationByte = (byte)((borderRotation += borderRotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            }
        }
        MapDecoration icon = new MapDecoration(type, pixelX, pixelZ, rotationByte, Optional.ofNullable(text));
        ((MapDecorationInjector)icon).setScale(scaleByte);
        MapDecoration previousIcon = this.accessor.getDecorations().put(key, icon);
        if (!icon.equals((Object)previousIcon)) {
            if (previousIcon != null && ((MapDecorationType)previousIcon.type().value()).trackCount()) {
                this.accessor.setTrackedDecorationCount(this.accessor.getTrackedDecorationCount() - 1);
            }
            if (((MapDecorationType)type.value()).trackCount()) {
                this.accessor.setTrackedDecorationCount(this.accessor.getTrackedDecorationCount() + 1);
            }
            this.accessor.invokeSetDecorationsDirty();
        }
    }

    public boolean toggleBanner(LevelAccessor world, BlockPos pos) {
        double x = (double)pos.getX() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        int scale = 1 << this.scale;
        double scaledX = (x - (double)this.displayedCenter.getX()) / (double)scale;
        double scaledZ = (z - (double)this.displayedCenter.getZ()) / (double)scale;
        if (scaledX >= -63.0 && scaledZ >= -63.0 && scaledX <= 63.0 && scaledZ <= 63.0) {
            MapBanner marker = MapBanner.fromWorld((BlockGetter)world, (BlockPos)pos);
            if (marker == null) {
                return false;
            }
            String key = marker.getId();
            if (this.accessor.getBannerMarkers().remove(key, marker)) {
                this.accessor.invokeRemoveDecoration(marker.getId());
                return true;
            }
            if (!this.isTrackedCountOverLimit(256)) {
                this.accessor.getBannerMarkers().put(key, marker);
                this.addDecoration((Holder<MapDecorationType>)marker.getDecoration(), world, key, x, z, 180.0, marker.name().orElse(null));
                return true;
            }
        }
        return false;
    }

    private void addTargetIcon(LevelAccessor world, BlockPos target) {
        if (target != null) {
            this.addDecoration((Holder<MapDecorationType>)MapDecorationTypes.TARGET_POINT, world, this.getTargetKey(target), target.getX(), target.getZ(), 180.0, null);
        }
    }

    private String getTargetKey(BlockPos start) {
        return String.format("target-%d-%d-%d", start.getX(), start.getY(), start.getZ());
    }

    public void startLocator(ServerLevel world) {
        if (this.targetId == null) {
            return;
        }
        this.locator = new StructureLocatorAsync(world, this.targetId, 5000L);
    }

    public void cancelLocator() {
        this.locator = null;
    }

    public BlockPos getDisplayedCenter() {
        return this.displayedCenter;
    }

    public void addTarget(LevelAccessor world, BlockPos pos) {
        this.targets.add(pos);
        this.addTargetIcon(world, pos);
    }

    public void setTargetId(@Nullable ResourceLocation targetId) {
        if (this.targetId != targetId) {
            this.targetId = targetId;
            this.setDirty();
        }
    }

    @Nullable
    public ResourceLocation getTargetId() {
        return this.targetId;
    }

    @Nullable
    public Vec3i getDisplayDelta() {
        return this.displayDelta;
    }

    public void clearDisplayDelta() {
        if (this.displayDelta != null) {
            int sampleSize = 1 << this.scale;
            Vec3i remainder = new Vec3i(this.displayDelta.getX() % sampleSize, 0, this.displayDelta.getZ() % sampleSize);
            Vec3i delta = this.displayDelta.subtract(remainder);
            this.displayedCenter = this.displayedCenter.offset(delta);
            this.displayDelta = remainder;
            if (this.locator != null) {
                this.locator.ping(this.displayedCenter, this::addTarget);
            }
        } else {
            this.displayDelta = Vec3i.ZERO;
        }
    }

    public void updateDimension(ResourceKey<Level> dimension) {
        if (!this.dimension.equals(dimension)) {
            this.dimension = dimension;
            this.displayDelta = null;
            this.targets.clear();
            this.targetId = null;
            this.setDirty();
        }
    }
}

