/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.Preenchanted;
import earth.terrarium.pastel.entity.entity.BedrockFishingBobberEntity;
import earth.terrarium.pastel.items.tools.PastelFishingRodItem;
import earth.terrarium.pastel.registries.PastelFluidTags;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;

public class BedrockFishingRodItem
extends PastelFishingRodItem
implements Preenchanted {
    public BedrockFishingRodItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments() {
        return Map.of(Enchantments.LUCK_OF_THE_SEA, 4);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canFishIn(FluidState fluidState) {
        return fluidState.is(PastelFluidTags.BEDROCK_ROD_FISHABLE_IN);
    }

    @Override
    public void spawnBobber(Player user, Level world, int luckOfTheSeaLevel, int waitTimeReductionTicks, int exuberanceLevel, int bigCatchLevel, int serendipityReelLevel, boolean inventoryInsertion, boolean shouldSmeltDrops) {
        world.addFreshEntity((Entity)new BedrockFishingBobberEntity(user, world, luckOfTheSeaLevel, waitTimeReductionTicks, exuberanceLevel, bigCatchLevel, serendipityReelLevel, inventoryInsertion, shouldSmeltDrops));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.bedrock_fishing_rod.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

