/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.Preenchanted;
import earth.terrarium.pastel.api.item.SlotReservingItem;
import earth.terrarium.pastel.api.item.SplittableItem;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.entity.entity.DraconicTwinswordEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DraconicTwinswordItem
extends SwordItem
implements SplittableItem,
SlotReservingItem,
Preenchanted,
ExtendedItemBar,
SlotBackgroundEffect {
    public static final float MAX_CHARGE_TIME = 60.0f;
    private final ItemAttributeModifiers modifiers;

    public DraconicTwinswordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, settings);
        this.modifiers = DraconicTwinswordItem.createAttributes((Tier)toolMaterial, (int)attackDamage, (float)attackSpeed);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (SlotReservingItem.isReservingSlot(stack) || remainingUseTicks == 0) {
            return;
        }
        float strength = Math.min((float)(this.getUseDuration(stack, user) - remainingUseTicks), 60.0f) / 60.0f;
        DraconicTwinswordEntity twinsword = DraconicTwinswordItem.initiateTwinswordEntity(stack, world, user, strength);
        world.addFreshEntity((Entity)twinsword);
        world.playSound(null, (Entity)twinsword, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 0.5f + strength / 2.0f, 1.0f);
        SlotReservingItem.reserve(stack, twinsword.getUUID());
        if (!world.isClientSide()) {
            stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
        }
        super.releaseUsing(stack, world, user, remainingUseTicks);
    }

    @NotNull
    private static DraconicTwinswordEntity initiateTwinswordEntity(ItemStack stack, Level world, LivingEntity user, float strength) {
        DraconicTwinswordEntity twinsword = new DraconicTwinswordEntity(world);
        twinsword.setOwner((Entity)user);
        twinsword.setPickupItemStack(stack);
        float yaw = user.getYRot();
        float pitch = user.getXRot();
        float f = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        twinsword.absMoveTo(user.getX() + (double)f * 1.334, user.getEyeY() - 0.2, user.getZ() + (double)h * 1.334);
        twinsword.setDeltaMovement(0.0, strength, 0.0);
        twinsword.setMaxPierce(Ench.getLevel((HolderLookup.Provider)world.registryAccess(), (ResourceKey<Enchantment>)Enchantments.PIERCING, stack));
        twinsword.hasImpulse = true;
        twinsword.hurtMarked = true;
        twinsword.pickup = AbstractArrow.Pickup.DISALLOWED;
        return twinsword;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 200;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.draconic_twinsword.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.draconic_twinsword.tooltip2").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.draconic_twinsword.tooltip3").withStyle(ChatFormatting.GRAY));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getCooldowns().isOnCooldown(stack.getItem()) || SlotReservingItem.isReservingSlot(stack)) {
                stack.remove(DataComponents.ATTRIBUTE_MODIFIERS);
            } else {
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)this.modifiers);
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) && !SlotReservingItem.isReservingSlot(stack);
    }

    @Override
    public ItemStack getSplitResult(ServerPlayer player, ItemStack parent) {
        ItemStack result = new ItemStack((ItemLike)PastelItems.DRAGON_TALON.get());
        int durability = parent.getDamageValue();
        if (SlotReservingItem.isReservingSlot(parent)) {
            durability += player.getAbilities().instabuild ? 0 : 500;
            player.getCooldowns().addCooldown(result.getItem(), 400);
        }
        result.applyComponents(parent.getComponents());
        result.remove(DataComponents.ATTRIBUTE_MODIFIERS);
        SlotReservingItem.free(result);
        result.setDamageValue(Math.min(durability, parent.getMaxDamage() - 1));
        this.sign(player, result);
        return result;
    }

    @Override
    public boolean canSplit(ServerPlayer player, InteractionHand occupiedHand, ItemStack stack) {
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return false;
        }
        return switch (occupiedHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> player.getItemInHand(InteractionHand.OFF_HAND).isEmpty();
            case InteractionHand.OFF_HAND -> player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
        };
    }

    @Override
    public void playSound(ServerPlayer player) {
        player.playNotifySound(PastelSounds.METALLIC_UNSHEATHE, SoundSource.PLAYERS, 0.5f, 0.8f + player.getRandom().nextFloat() * 0.4f);
    }

    public static ItemStack findThrownStack(Player player, UUID id) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!SlotReservingItem.isReserver(stack, id)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments() {
        return Map.of(Enchantments.SWEEPING_EDGE, 5);
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable Player player, ItemStack stack) {
        if (player == null || SlotReservingItem.isReservingSlot(stack) || player.getItemInHand(player.getUsedItemHand()) != stack) {
            return true;
        }
        return !player.isUsingItem();
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        if (player == null || SlotReservingItem.isReservingSlot(stack) || !player.isUsingItem()) {
            return ExtendedItemBar.PASS;
        }
        ItemStack activeStack = player.getItemInHand(player.getUsedItemHand());
        if (activeStack != stack) {
            return ExtendedItemBar.PASS;
        }
        int progress = Math.round(Mth.clampedLerp((float)0.0f, (float)13.0f, (float)((float)player.getTicksUsingItem() / 60.0f)));
        return new ExtendedItemBar.BarSignature(2, 13, 13, progress, 1, -1184512, 2, -16777216);
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return -1184512;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.CHANNELING) || enchantment.is(Enchantments.PIERCING) || enchantment.is(PastelEnchantments.INERTIA);
    }

    public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        AABB box = super.getSweepHitBox(stack, player, target);
        int channeling = Ench.getLevel((HolderLookup.Provider)player.registryAccess(), (ResourceKey<Enchantment>)Enchantments.CHANNELING, stack) + 1;
        double size = (double)(channeling * 2) + 0.5;
        box = box.inflate(size, (double)channeling * 0.4, size);
        return box;
    }
}

