/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.item.ActivatableItem;
import earth.terrarium.pastel.api.item.SplitDamageHandler;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DreamflayerItem
extends SwordItem
implements InkPowered,
ActivatableItem,
SplitDamageHandler,
SlotBackgroundEffect {
    public static final InkColor USED_COLOR = InkColors.RED;
    public static final long INK_COST_FOR_ACTIVATION = 200L;
    public static final long INK_COST_PER_SECOND = 20L;
    public static final float ARMOR_DIFFERENCE_DAMAGE_MULTIPLIER = 2.5f;
    private final float baseAttackDamage;
    private final float baseAttackSpeed;

    public DreamflayerItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, settings.attributes(SwordItem.createAttributes((Tier)toolMaterial, (int)attackDamage, (float)attackSpeed)));
        this.baseAttackDamage = attackDamage;
        this.baseAttackSpeed = attackSpeed;
    }

    public static float getDamageAfterModifier(float amount, LivingEntity attacker, LivingEntity target) {
        float damageMultiplier = ((float)target.getArmorValue() + 2.5f) / ((float)attacker.getArmorValue() + 2.5f);
        return amount * damageMultiplier;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(world, user, stack, remainingUseTicks);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            boolean isActivated = ActivatableItem.isActivated(stack);
            if (isActivated) {
                this.setActivated(stack, false);
                if (!world.isClientSide) {
                    world.playSound(null, user.getX(), user.getY(), user.getZ(), PastelSounds.DREAMFLAYER_DEACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (InkPowered.tryDrainEnergy(user, USED_COLOR, 200L)) {
                this.setActivated(stack, true);
                if (!world.isClientSide) {
                    world.playSound(null, user.getX(), user.getY(), user.getZ(), PastelSounds.DREAMFLAYER_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (!world.isClientSide) {
                world.playSound(null, user.getX(), user.getY(), user.getZ(), PastelSounds.DREAMFLAYER_DEACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        ServerPlayer player;
        super.inventoryTick(stack, world, entity, slot, selected);
        if (world.isClientSide) {
            if (ActivatableItem.isActivated(stack)) {
                Vec3 pos = entity.position();
                world.addParticle((ParticleOptions)ColoredCraftingParticleEffect.RED, entity.getRandomX(1.0), pos.y() + 1.05, entity.getRandomZ(1.0), 0.0, 0.1, 0.0);
            }
        } else if (world.getGameTime() % 20L == 0L && ActivatableItem.isActivated(stack) && entity instanceof ServerPlayer && !InkPowered.tryDrainEnergy((Player)(player = (ServerPlayer)entity), USED_COLOR, 20L)) {
            this.setActivated(stack, false);
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), PastelSounds.DREAMFLAYER_DEACTIVATE, SoundSource.PLAYERS, 0.8f, 1.0f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.dreamflayer.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.dreamflayer.tooltip2").withStyle(ChatFormatting.GRAY));
        if (ActivatableItem.isActivated(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.dreamflayer.tooltip.activated").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.dreamflayer.tooltip.deactivated", (Object[])new Object[]{USED_COLOR.getColoredInkName()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !after.is((Item)this) || ActivatableItem.isActivated(before) != ActivatableItem.isActivated(after);
    }

    @Override
    public void setActivated(ItemStack stack, boolean active) {
        if (ActivatableItem.isActivated(stack) != active) {
            float damage = this.baseAttackDamage * (active ? 1.5f : 1.0f);
            float speed = this.baseAttackSpeed * (active ? 0.75f : 1.0f);
            stack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, comp -> {
                ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
                for (ItemAttributeModifiers.Entry entry : comp.modifiers()) {
                    if (entry.modifier().is(BASE_ATTACK_DAMAGE_ID)) {
                        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                    }
                    if (entry.modifier().is(BASE_ATTACK_SPEED_ID)) {
                        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                        continue;
                    }
                    builder.add(entry.attribute(), entry.modifier(), entry.slot());
                }
                return builder.build();
            });
            ActivatableItem.setActivated(stack, active);
        }
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInkPoweredTooltip(List<Component> tooltip) {
        InkPowered.super.addInkPoweredTooltip(tooltip);
    }

    @Override
    public SplitDamageHandler.DamageComposition getDamageComposition(LivingEntity attacker, LivingEntity target, ItemStack stack, float damage) {
        float newDamage = DreamflayerItem.getDamageAfterModifier(damage, attacker, target);
        SplitDamageHandler.DamageComposition composition = new SplitDamageHandler.DamageComposition();
        if (ActivatableItem.isActivated(stack)) {
            composition.addPlayerOrEntity(attacker, newDamage * 0.5f);
            composition.add(attacker.damageSources().magic(), newDamage * 0.25f);
            composition.add(PastelDamageTypes.setHealth(attacker.level(), attacker), newDamage * 0.25f);
        } else {
            composition.addPlayerOrEntity(attacker, newDamage * 0.75f);
            composition.add(attacker.damageSources().magic(), newDamage * 0.25f);
        }
        return composition;
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        if (ActivatableItem.isActivated(stack)) {
            return SlotBackgroundEffect.SlotEffect.FULL_PACKAGE;
        }
        boolean usable = InkPowered.hasAvailableInk(player, new InkCost(InkColors.RED, 200L));
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return -972236;
    }
}

