/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.components.WorkstaffComponent;
import earth.terrarium.pastel.entity.entity.MiningProjectileEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.WorkstaffItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlassCrestWorkstaffItem
extends WorkstaffItem
implements SlotBackgroundEffect {
    public static final int COOLDOWN_DURATION_TICKS = 10;
    public static final InkCost PROJECTILE_COST = new InkCost(InkColors.WHITE, 50L);

    public GlassCrestWorkstaffItem(Tier material, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public static boolean canShoot(ItemStack stack) {
        return ((WorkstaffComponent)stack.getOrDefault(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).canShoot();
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        InteractionResultHolder<ItemStack> result = super.use(level, user, hand);
        if (!result.getResult().consumesAction()) {
            ItemStack stack = user.getItemInHand(hand);
            if (GlassCrestWorkstaffItem.canShoot(stack) && InkPowered.tryDrainEnergy(user, PROJECTILE_COST)) {
                user.getCooldowns().addCooldown((Item)this, 10);
                user.playSound(PastelSounds.CAST_RADIANCE, 0.5f, Support.varFloat(level.random, 0.2f));
                MiningProjectileEntity.shoot(level, (LivingEntity)user, user.getItemInHand(hand));
                stack.hurtAndBreak(2, (LivingEntity)user, EquipmentSlot.MAINHAND);
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return result;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (GlassCrestWorkstaffItem.canShoot(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.workstaff.tooltip.projectile").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.workstaff.tooltip.projectiles_disabled").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        boolean usable = InkPowered.hasAvailableInk(player, PROJECTILE_COST);
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        if (player != null) {
            RegistryAccess lookup = player.level().registryAccess();
            boolean resonance = Ench.hasEnchantment((HolderLookup.Provider)lookup, PastelEnchantments.RESONANCE, stack);
            boolean silkTouch = Ench.hasEnchantment((HolderLookup.Provider)lookup, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, stack);
            boolean fortune = Ench.hasEnchantment((HolderLookup.Provider)lookup, (ResourceKey<Enchantment>)Enchantments.FORTUNE, stack);
            if (resonance) {
                return -1;
            }
            if (silkTouch) {
                return -10747923;
            }
            if (fortune) {
                return -8741121;
            }
        }
        return -5395027;
    }
}

