/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import com.cmdpro.databank.misc.ColorGradient;
import earth.terrarium.pastel.api.item.HasColorGradient;
import earth.terrarium.pastel.api.item.SplitDamageHandler;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.ParryingSwordItem;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LightGreatswordItem
extends ParryingSwordItem
implements SplitDamageHandler,
HasColorGradient {
    private final ColorGradient lungeGradient;
    private final int barColor;

    public LightGreatswordItem(Tier material, int attackDamage, float attackSpeed, float crit, float reach, int barColor, ColorGradient lungeGradient, Item.Properties settings) {
        super(material, attackDamage, attackSpeed, crit, reach, settings);
        this.barColor = barColor;
        this.lungeGradient = lungeGradient;
    }

    public LightGreatswordItem(Tier material, int attackDamage, float attackSpeed, float crit, float reach, int barColor, Item.Properties settings) {
        this(material, attackDamage, attackSpeed, crit, reach, barColor, null, settings);
    }

    @Override
    public float getBlockingMultiplier(DamageSource source, ItemStack stack, LivingEntity entity, int usedTime) {
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            return 0.0f;
        }
        if (this.canPerfectParry(stack, entity, usedTime)) {
            return 0.05f;
        }
        if (this.canBluffParry(stack, entity, usedTime)) {
            return 0.2f;
        }
        if ((float)usedTime <= (float)this.getMaxShieldingTime(entity, stack) / 2.0f) {
            return 0.5f;
        }
        return 0.75f;
    }

    @Override
    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        super.releaseUsing(stack, world, user, remainingUseTicks);
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        int maxShieldTime = this.getMaxShieldingTime(user, stack);
        if (!player.onGround() && maxShieldTime - remainingUseTicks > 5 && !MiscPlayerData.get(player).isParrying()) {
            Vec3 chargeDir = Vec3.directionFromRotation((float)player.getXRot(), (float)player.getYRot());
            float chargeStrength = Math.min((float)(maxShieldTime - remainingUseTicks) / (float)maxShieldTime + 0.2f, 1.0f);
            player.push(chargeDir.normalize().scale((double)(this.getLungeSpeed() * chargeStrength)));
            player.playSound(PastelSounds.LUNGE, 2.0f, 0.8f + player.getRandom().nextFloat() * 0.2f);
            MiscPlayerData.get(player).initiateLungeState((Item)this);
        }
    }

    public float getLungeSpeed() {
        return 1.0f;
    }

    @Override
    public int getBarColor() {
        return this.barColor;
    }

    protected void applyLungeHitEffects(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.getType() == EntityType.ENDERMAN) {
            return;
        }
        Holder effect = target.isInvertedHealAndHarm() ? MobEffects.REGENERATION : MobEffects.POISON;
        int sharpness = Ench.getLevel((HolderLookup.Provider)target.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.SHARPNESS, stack);
        target.addEffect(new MobEffectInstance(effect, 20 * (5 + sharpness), 1));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (attacker instanceof Player && MiscPlayerData.get(player = (Player)attacker).isLunging()) {
            MiscPlayerData.get(player).endLunge();
            target.playSound(PastelSounds.LUNGE_CRIT, 1.0f, 0.9f + target.getRandom().nextFloat() * 0.2f);
            this.applyLungeHitEffects(stack, target, attacker);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public SplitDamageHandler.DamageComposition getDamageComposition(LivingEntity attacker, LivingEntity target, ItemStack stack, float damage) {
        Player player;
        SplitDamageHandler.DamageComposition composition = new SplitDamageHandler.DamageComposition();
        DamageSource source = composition.getPlayerOrEntity(attacker);
        if (attacker instanceof Player && MiscPlayerData.get(player = (Player)attacker).isLunging()) {
            source = PastelDamageTypes.impaling(player.level(), (Entity)player);
        }
        composition.add(source, damage);
        return composition;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        Player player;
        return entity instanceof Player && MiscPlayerData.get(player = (Player)entity).isLunging();
    }

    @Override
    public ColorGradient getColorGradient(ResourceLocation gradient) {
        if (gradient.equals((Object)HasColorGradient.LUNGE)) {
            return this.lungeGradient;
        }
        return null;
    }
}

