/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.MoltenFishingBobberEntity;
import earth.terrarium.pastel.items.tools.PastelFishingRodItem;
import earth.terrarium.pastel.registries.PastelFluidTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;

public class MoltenRodItem
extends PastelFishingRodItem {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("unlocks/equipment/molten_rod");

    public MoltenRodItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public boolean canFishIn(FluidState fluidState) {
        return fluidState.is(PastelFluidTags.MOLTEN_ROD_FISHABLE_IN);
    }

    @Override
    public void spawnBobber(Player user, Level world, int luckBonus, int waitTimeReductionTicks, int exuberanceLevel, int bigCatchLevel, int serendipityReelLevel, boolean inventoryInsertion, boolean shouldSmeltDrops) {
        world.addFreshEntity((Entity)new MoltenFishingBobberEntity(user, world, luckBonus, waitTimeReductionTicks, exuberanceLevel, bigCatchLevel, serendipityReelLevel, inventoryInsertion));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.molten_rod.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.molten_rod.tooltip2").withStyle(ChatFormatting.GRAY));
    }
}

