/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.particle.effect.DynamicParticleEffect;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NightfallsBladeItem
extends TieredItem
implements InkPoweredPotionFillable,
SlotBackgroundEffect {
    private static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("unlocks/equipment/nightfalls_blade");

    public NightfallsBladeItem(Tier material, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(material, settings.attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)((float)attackDamage + material.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(PastelEntityAttributes.REACH_MODIFIER_ID, -1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 2;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public long adjustFinalCostFor(@NotNull InkPoweredStatusEffectInstance instance) {
        boolean mod = PastelMobEffects.isStrongSleepEffect(instance);
        return Math.round(Math.pow(instance.getInkCost().cost(), 1.75 + (double)instance.getStatusEffectInstance().getAmplifier() + (double)mod));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (target.isAlive() && attacker instanceof Player && DatabankUtils.hasAdvancement((Player)(player = (Player)attacker), (ResourceLocation)UNLOCK_IDENTIFIER)) {
            List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
            for (InkPoweredStatusEffectInstance instance : effects) {
                if (!InkPowered.tryDrainEnergy(player, instance.getInkCost().color(), instance.getInkCost().cost())) continue;
                Level world = attacker.level();
                if (world.isClientSide) {
                    world.addParticle((ParticleOptions)new DynamicParticleEffect((ParticleType<?>)ParticleTypes.EFFECT, 0.1f, ColorHelper.colorIntToVec(((MobEffect)instance.getStatusEffectInstance().getEffect().value()).getColor()), 0.5f, 120, true, true), target.getRandomX(0.5), target.getY(0.5), target.getRandomZ(0.5), (double)world.random.nextFloat() - 0.5, (double)world.random.nextFloat() - 0.5, (double)world.random.nextFloat() - 0.5);
                    continue;
                }
                target.addEffect(instance.getStatusEffectInstance(), (Entity)attacker);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || !((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.appendPotionFillableTooltip(stack, tooltip, Component.translatable((String)"item.pastel.nightfalls_blade.when_struck"), true, context.tickRate());
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return SlotBackgroundEffect.SlotEffect.NONE;
        }
        InkPoweredStatusEffectInstance effect = effects.getFirst();
        boolean usable = InkPowered.hasAvailableInk(player, new InkCost(effect.getInkCost().color(), this.adjustFinalCostFor(effect)));
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.BORDER;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return 0;
        }
        return effects.getFirst().getColor();
    }

    @Override
    public float getEffectOpacity(@Nullable Player player, ItemStack stack, float tickDelta) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
        if (effects.isEmpty()) {
            return 0.0f;
        }
        InkPoweredStatusEffectInstance effect = effects.getFirst();
        if (InkPowered.hasAvailableInk(player, new InkCost(effect.getInkCost().color(), this.adjustFinalCostFor(effect)))) {
            return 1.0f;
        }
        if (player == null) {
            return 0.0f;
        }
        long time = player.level().getGameTime();
        return (float)(Math.sin(((float)time + tickDelta) / 30.0f) * (double)0.3f + 0.3);
    }
}

