/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.item.Preenchanted;
import earth.terrarium.pastel.capabilities.AreaMiningHandler;
import earth.terrarium.pastel.components.WorkstaffComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.inventories.WorkstaffScreenHandler;
import earth.terrarium.pastel.items.tools.MultiToolItem;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbility;

public class WorkstaffItem
extends MultiToolItem
implements AreaMiningHandler,
Preenchanted {
    protected static final InkCost BASE_COST_PER_AOE_MINING_RANGE_INCREMENT = new InkCost(InkColors.WHITE, 3L);

    public WorkstaffItem(Tier material, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.isShiftKeyDown()) {
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)user;
                serverPlayerEntity.openMenu(this.createScreenHandlerFactory(user.getItemInHand(hand)));
            }
            return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
        }
        return super.use(world, user, hand);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        int range = (Integer)stack.getOrDefault(PastelDataComponentTypes.AOE, (Object)0);
        if (range > 0) {
            int displayedRange = 1 + range + range;
            tooltip.add((Component)Component.translatable((String)"item.pastel.workstaff.tooltip.mining_range", (Object[])new Object[]{displayedRange, displayedRange}).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean itemAbilitiesEnabled(ItemStack stack) {
        return ((WorkstaffComponent)stack.getOrDefault(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).canTill();
    }

    public MenuProvider createScreenHandlerFactory(ItemStack itemStack) {
        return new SimpleMenuProvider((syncId, inventory, player) -> new WorkstaffScreenHandler(syncId, inventory, itemStack), (Component)Component.translatable((String)"item.pastel.workstaff"));
    }

    public static void applyToggle(Player player, ItemStack stack, GUIToggle toggle) {
        switch (toggle.ordinal()) {
            case 3: {
                stack.set(PastelDataComponentTypes.AOE, (Object)0);
                player.displayClientMessage(toggle.getTriggerText(), true);
                break;
            }
            case 4: {
                stack.set(PastelDataComponentTypes.AOE, (Object)1);
                player.displayClientMessage(toggle.getTriggerText(), true);
                break;
            }
            case 5: {
                stack.set(PastelDataComponentTypes.AOE, (Object)2);
                player.displayClientMessage(toggle.getTriggerText(), true);
                break;
            }
            case 1: {
                WorkstaffItem.enchantAndRemoveOthers(player, stack, toggle.getTriggerText(), (ResourceKey<Enchantment>)Enchantments.FORTUNE);
                break;
            }
            case 0: {
                WorkstaffItem.enchantAndRemoveOthers(player, stack, toggle.getTriggerText(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH);
                break;
            }
            case 2: {
                WorkstaffItem.enchantAndRemoveOthers(player, stack, toggle.getTriggerText(), PastelEnchantments.RESONANCE);
                break;
            }
            case 6: {
                stack.update(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(true, comp.canShoot(), comp.fortuneLevel()));
                player.displayClientMessage(toggle.getTriggerText(), true);
                break;
            }
            case 7: {
                stack.update(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(false, comp.canShoot(), comp.fortuneLevel()));
                player.displayClientMessage(toggle.getTriggerText(), true);
                break;
            }
            case 8: {
                stack.update(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(comp.canTill(), true, comp.fortuneLevel()));
                player.displayClientMessage(toggle.getTriggerText(), true);
                break;
            }
            case 9: {
                stack.update(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(comp.canTill(), false, comp.fortuneLevel()));
                player.displayClientMessage(toggle.getTriggerText(), true);
            }
        }
    }

    private static void enchantAndRemoveOthers(Player player, ItemStack stack, Component message, ResourceKey<Enchantment> enchantment) {
        RegistryAccess registryLookup = player.level().registryAccess();
        int existingLevel = Ench.getLevel((HolderLookup.Provider)registryLookup, enchantment, stack);
        if (existingLevel > 0) {
            player.displayClientMessage((Component)Component.translatable((String)"item.pastel.workstaff.message.already_has_the_enchantment"), true);
            return;
        }
        int level = 1;
        if (enchantment == Enchantments.FORTUNE) {
            level = ((WorkstaffComponent)stack.getOrDefault(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).fortuneLevel();
        } else {
            int fortuneLevel = Ench.getLevel((HolderLookup.Provider)registryLookup, (ResourceKey<Enchantment>)Enchantments.FORTUNE, stack);
            stack.update(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT, comp -> new WorkstaffComponent(comp.canTill(), comp.canShoot(), Math.max(fortuneLevel, 1)));
        }
        ItemStack newStack = stack.copy();
        Tuple<ItemStack, Integer> removeResult = Ench.removeEnchantments((HolderLookup.Provider)registryLookup, newStack, Enchantments.SILK_TOUCH, PastelEnchantments.RESONANCE, Enchantments.FORTUNE);
        if ((Integer)removeResult.getB() == 0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                WorkstaffItem.triggerUnenchantedWorkstaffAdvancement(serverPlayerEntity);
            }
        } else {
            Tuple<Boolean, ItemStack> addResult = Ench.addOrUpgradeEnchantment((HolderLookup.Provider)registryLookup, (ItemStack)removeResult.getA(), enchantment, level, false, DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.APPLY_CONFLICTING_ENCHANTMENTS));
            if (((Boolean)addResult.getA()).booleanValue()) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)((ItemStack)addResult.getB()).getEnchantments());
                player.displayClientMessage(message, true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.pastel.workstaff.message.would_result_in_conflicting_enchantments"), true);
            }
        }
    }

    private static void triggerUnenchantedWorkstaffAdvancement(ServerPlayer player) {
        player.playNotifySound(PastelSounds.USE_FAIL, SoundSource.PLAYERS, 0.75f, 1.0f);
        Support.grantAdvancementCriterion(player, "lategame/trigger_unenchanted_workstaff", "code_triggered");
    }

    @Override
    public Vec3i getMiningArea(Player player, ItemStack stack, BlockPos pos) {
        Integer range = (Integer)stack.getOrDefault(PastelDataComponentTypes.AOE, (Object)0);
        int inkCost = (int)Math.pow(BASE_COST_PER_AOE_MINING_RANGE_INCREMENT.cost(), range.intValue());
        if (range == 0 || !InkPowered.tryDrainEnergy(player, BASE_COST_PER_AOE_MINING_RANGE_INCREMENT.color(), (long)inkCost)) {
            return Vec3i.ZERO;
        }
        return new Vec3i(range.intValue(), range.intValue(), 0);
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments() {
        return Map.of(Enchantments.FORTUNE, 4);
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        if (!((WorkstaffComponent)stack.getOrDefault(PastelDataComponentTypes.WORKSTAFF, (Object)WorkstaffComponent.DEFAULT)).canTill()) {
            return false;
        }
        return super.canPerformAction(stack, itemAbility);
    }

    public static enum GUIToggle {
        SELECT_SILK_TOUCH("item.pastel.workstaff.message.silk_touch"),
        SELECT_FORTUNE("item.pastel.workstaff.message.fortune"),
        SELECT_RESONANCE("item.pastel.workstaff.message.resonance"),
        SELECT_1x1("item.pastel.workstaff.message.1x1"),
        SELECT_3x3("item.pastel.workstaff.message.3x3"),
        SELECT_5x5("item.pastel.workstaff.message.5x5"),
        ENABLE_RIGHT_CLICK_ACTIONS("item.pastel.workstaff.message.enabled_right_click_actions"),
        DISABLE_RIGHT_CLICK_ACTIONS("item.pastel.workstaff.message.disabled_right_click_actions"),
        ENABLE_PROJECTILES("item.pastel.workstaff.message.enabled_projectiles"),
        DISABLE_PROJECTILES("item.pastel.workstaff.message.disabled_projectiles");

        private final String triggerText;

        private GUIToggle(String triggerText) {
            this.triggerText = triggerText;
        }

        public Component getTriggerText() {
            return Component.translatable((String)this.triggerText);
        }
    }
}

