/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tooltip;

import earth.terrarium.pastel.api.gui.PastelTooltipComponent;
import earth.terrarium.pastel.api.item.ItemStorage;
import earth.terrarium.pastel.items.tooltip.ItemStorageTooltipData;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BottomlessBundleTooltipComponent
implements PastelTooltipComponent {
    private static final int MAX_DISPLAYED_SLOTS = 5;
    private final List<ItemStack> itemStacks;
    private final int displayedSlotCount;
    private final boolean drawDots;

    public BottomlessBundleTooltipComponent(ItemStorageTooltipData data) {
        ItemStorage storage = data.storage();
        long amount = storage.getCount();
        long maxCount = storage.stackSize();
        double totalStacks = (float)amount / (float)maxCount;
        this.displayedSlotCount = Math.max(2, Math.min(6, (int)Math.ceil(totalStacks) + 1));
        this.itemStacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
        for (int i = 0; i < Math.min(5, this.displayedSlotCount + 1); ++i) {
            long stackAmount = Math.min(Math.min(maxCount, amount - (long)i * maxCount), Integer.MAX_VALUE);
            this.itemStacks.set(i, storage.stack((int)stackAmount));
        }
        this.drawDots = totalStacks > 5.0;
    }

    public int getHeight() {
        return 26;
    }

    public int getWidth(Font textRenderer) {
        return this.displayedSlotCount * 20 + 2 + 4;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        int n = x + 1;
        int o = y + 1;
        for (int i = 0; i < Math.min(6, this.displayedSlotCount); ++i) {
            if (i == this.displayedSlotCount - 1) {
                if (this.displayedSlotCount == 6) {
                    if (this.drawDots) {
                        PastelTooltipComponent.drawDottedSlot(context, n + 90, o);
                        continue;
                    }
                    PastelTooltipComponent.drawSlot(context, n + i * 18, o, i, ItemStack.EMPTY, textRenderer);
                    continue;
                }
                if (this.itemStacks.size() - 1 < i) {
                    PastelTooltipComponent.drawSlot(context, n + i * 18, o, i, ItemStack.EMPTY, textRenderer);
                    continue;
                }
                PastelTooltipComponent.drawSlot(context, n + i * 18, o, i, this.itemStacks.get(i), textRenderer);
                continue;
            }
            PastelTooltipComponent.drawSlot(context, n + i * 18, o, i, this.itemStacks.get(i), textRenderer);
        }
        PastelTooltipComponent.drawOutline(context, x, y, this.displayedSlotCount, 1);
    }
}

