/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tooltip;

import earth.terrarium.pastel.api.gui.PastelTooltipComponent;
import earth.terrarium.pastel.items.tooltip.CraftingTabletTooltipData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CraftingTabletTooltipComponent
implements PastelTooltipComponent {
    private final ItemStack itemStack;
    private final FormattedCharSequence description;

    public CraftingTabletTooltipComponent(CraftingTabletTooltipData data) {
        this.itemStack = data.getItemStack();
        this.description = data.getDescription().getVisualOrderText();
    }

    public int getHeight() {
        return 24;
    }

    public int getWidth(Font textRenderer) {
        return textRenderer.width(this.description) + 28;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        int n = x + 1;
        int o = y + 1;
        PastelTooltipComponent.drawSlot(context, n, o, 0, this.itemStack, textRenderer);
        PastelTooltipComponent.drawOutline(context, x, y, 1, 1);
    }

    public void renderText(Font textRenderer, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource immediate) {
        textRenderer.drawInBatch(this.description, (float)x + 26.0f, (float)y + 6.0f, 0xA8A8A8, true, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

