/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class AttackRingItem
extends PastelTrinketItem {
    public static final ResourceLocation ATTACK_RING_DAMAGE_ID = PastelCommon.locate("jeopardant");
    public static final String ATTACK_RING_DAMAGE_NAME = "pastel:jeopardant";

    public AttackRingItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/jeopardant"));
    }

    public static double getAttackModifierForEntity(LivingEntity entity) {
        if (entity == null) {
            return 0.0;
        }
        double mod = entity.getMaxHealth() / (entity.getHealth() * entity.getHealth() + 1.0f);
        return Math.max(0.0, 1.0 + Math.log10(mod));
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity entity = slotContext.entity();
        if (entity.getAttributes().hasModifier(Attributes.ATTACK_DAMAGE, ATTACK_RING_DAMAGE_ID)) {
            Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
            map.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ATTACK_RING_DAMAGE_ID, AttackRingItem.getAttackModifierForEntity(entity), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            entity.getAttributes().removeAttributeModifiers(map);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        Minecraft client = Minecraft.getInstance();
        long mod = Math.round(AttackRingItem.getAttackModifierForEntity((LivingEntity)client.player) * 100.0);
        if (mod == 0L) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.jeopardant.tooltip.damage_zero"));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.jeopardant.tooltip.damage", (Object[])new Object[]{mod}));
        }
    }
}

