/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayDivinityAppliedEffectsPayload;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class CircletOfArroganceItem
extends PastelTrinketItem {
    private static final int TRIGGER_EVERY_X_TICKS = 240;
    private static final int EFFECT_DURATION = 250;

    public CircletOfArroganceItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/circlet_of_arrogance"));
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity entity = slotContext.entity();
        CircletOfArroganceItem.giveEffect(entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            PlayDivinityAppliedEffectsPayload.playDivinityAppliedEffects(serverPlayerEntity);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        Level world = slotContext.entity().level();
        if (!world.isClientSide && world.getGameTime() % 240L == 0L) {
            CircletOfArroganceItem.giveEffect(slotContext.entity());
        }
    }

    private static void giveEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(PastelMobEffects.DIVINITY, 250, 0, true, true));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.circlet_of_arrogance.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

