/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.progression.PastelCriteria;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class PastelTrinketItem
extends Item
implements ICurioItem {
    private final ResourceLocation unlockIdentifier;

    public PastelTrinketItem(Item.Properties settings, ResourceLocation unlockIdentifier) {
        super(settings);
        this.unlockIdentifier = unlockIdentifier;
    }

    public static boolean hasEquipped(SlotContext slotContext, Item item) {
        return PastelTrinketItem.hasEquipped(slotContext.entity(), item);
    }

    public static boolean hasEquipped(LivingEntity entity, Item item) {
        return PastelTrinketItem.getFirstEquipped(entity, item).isPresent();
    }

    public static Optional<ItemStack> getFirstEquipped(LivingEntity entity, Item item) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(inventory -> inventory.findFirstCurio(item)).map(SlotResult::stack);
    }

    public ResourceLocation getUnlockIdentifier() {
        return this.unlockIdentifier;
    }

    public boolean canEquipMoreThanOne() {
        return false;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        if (!super.canEquip(slotContext, stack)) {
            return false;
        }
        return this.canEquipMoreThanOne() || !PastelTrinketItem.hasEquipped(slotContext.entity(), (Item)this);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)livingEntity;
            PastelCriteria.TRINKET_CHANGE.trigger(serverPlayerEntity);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)livingEntity;
            PastelCriteria.TRINKET_CHANGE.trigger(serverPlayerEntity);
        }
    }
}

