/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class WhispyCircletItem
extends PastelTrinketItem {
    private static final int TRIGGER_EVERY_X_TICKS = 100;
    private static final int NEGATIVE_EFFECT_SHORTENING_TICKS = 200;
    public static final ResourceLocation ATTRIBUTE_ID = PastelCommon.locate("whispy_circlet_mental_presence");

    public WhispyCircletItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/whispy_circlet"));
    }

    public static void removeSingleStatusEffect(@NotNull LivingEntity entity, MobEffectCategory category) {
        Collection currentEffects = entity.getActiveEffects();
        if (currentEffects.isEmpty()) {
            return;
        }
        ArrayList<MobEffectInstance> negativeEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance statusEffectInstance : currentEffects) {
            Holder effect = statusEffectInstance.getEffect();
            if (((MobEffect)effect.value()).getCategory() != category || effect.is(PastelMobEffectTags.SOPORIFIC) || effect.is(PastelMobEffectTags.BYPASSES_WHISPY_CIRCLET)) continue;
            negativeEffects.add(statusEffectInstance);
        }
        if (negativeEffects.isEmpty()) {
            return;
        }
        Level world = entity.level();
        int randomIndex = world.random.nextInt(negativeEffects.size());
        entity.removeEffect(((MobEffectInstance)negativeEffects.get(randomIndex)).getEffect());
    }

    public static void removeNegativeStatusEffects(@NotNull LivingEntity entity) {
        HashSet<Holder> effectsToRemove = new HashSet<Holder>();
        for (MobEffectInstance instance : entity.getActiveEffects()) {
            if (!WhispyCircletItem.affects((Holder<MobEffect>)instance.getEffect())) continue;
            effectsToRemove.add(instance.getEffect());
        }
        for (Holder effect : effectsToRemove) {
            entity.removeEffect(effect);
        }
    }

    public static void shortenNegativeStatusEffects(@NotNull LivingEntity entity, int duration) {
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        ArrayList<Holder> effectTypesToClear = new ArrayList<Holder>();
        for (MobEffectInstance instance : entity.getActiveEffects()) {
            if (!WhispyCircletItem.affects((Holder<MobEffect>)instance.getEffect())) continue;
            int newDurationTicks = instance.getDuration() - duration;
            if (newDurationTicks > 0) {
                newEffects.add(new MobEffectInstance(instance.getEffect(), newDurationTicks, instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon()));
            }
            if (effectTypesToClear.contains(instance.getEffect())) continue;
            effectTypesToClear.add(instance.getEffect());
        }
        for (Holder effectTypeToClear : effectTypesToClear) {
            entity.removeEffect(effectTypeToClear);
        }
        for (MobEffectInstance newEffect : newEffects) {
            entity.addEffect(newEffect);
        }
    }

    public static boolean affects(Holder<MobEffect> effect) {
        return ((MobEffect)effect.value()).getCategory() == MobEffectCategory.HARMFUL && !effect.is(PastelMobEffectTags.BYPASSES_WHISPY_CIRCLET);
    }

    public static void preventPhantomSpawns(@NotNull ServerPlayer serverPlayerEntity) {
        serverPlayerEntity.getStats().setValue((Player)serverPlayerEntity, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), 0);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.whispy_circlet.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.whispy_circlet.tooltip2").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.whispy_circlet.tooltip3").withStyle(ChatFormatting.GRAY));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        Level world = entity.level();
        if (!world.isClientSide) {
            long time = entity.level().getGameTime();
            if (time % 100L == 0L) {
                WhispyCircletItem.shortenNegativeStatusEffects(entity, 200);
            }
            if (time % 10000L == 0L && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                WhispyCircletItem.preventPhantomSpawns(serverPlayerEntity);
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        modifiers.put(PastelEntityAttributes.MENTAL_PRESENCE, (Object)new AttributeModifier(ATTRIBUTE_ID, 0.3, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }
}

