/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.loot.PastelLootFunctionTypes;
import earth.terrarium.pastel.mixin.accessors.BiomeAccessor;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FermentRandomlyLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<FermentRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(i -> FermentRandomlyLootFunction.commonFields((RecordCodecBuilder.Instance)i).and(i.group((App)Codec.either((Codec)ResourceLocation.CODEC, FermentationData.CODEC).fieldOf("fermentation").forGetter(c -> c.fermentation), (App)NumberProviders.CODEC.fieldOf("days_fermented").forGetter(c -> c.daysFermented), (App)NumberProviders.CODEC.fieldOf("thickness").forGetter(c -> c.thickness))).apply((Applicative)i, FermentRandomlyLootFunction::new));
    private final Either<ResourceLocation, FermentationData> fermentation;
    private final NumberProvider daysFermented;
    private final NumberProvider thickness;

    public FermentRandomlyLootFunction(List<LootItemCondition> conditions, Either<ResourceLocation, FermentationData> fermentation, NumberProvider daysFermented, NumberProvider thickness) {
        super(conditions);
        this.fermentation = fermentation;
        this.daysFermented = daysFermented;
        this.thickness = thickness;
    }

    public FermentRandomlyLootFunction(List<LootItemCondition> conditions, @NotNull ResourceLocation fermentationRecipeIdentifier, NumberProvider daysFermented, NumberProvider thickness) {
        this(conditions, (Either<ResourceLocation, FermentationData>)Either.left((Object)fermentationRecipeIdentifier), daysFermented, thickness);
    }

    public FermentRandomlyLootFunction(List<LootItemCondition> conditions, @NotNull FermentationData fermentationData, NumberProvider daysFermented, NumberProvider thickness) {
        this(conditions, (Either<ResourceLocation, FermentationData>)Either.right((Object)fermentationData), daysFermented, thickness);
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return PastelLootFunctionTypes.FERMENT_RANDOMLY;
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        FermentationData fermentationData = (FermentationData)this.fermentation.map(id -> {
            Recipe patt0$temp;
            Optional recipe = context.getLevel().getRecipeManager().byKey(id);
            if (recipe.isPresent() && (patt0$temp = ((RecipeHolder)recipe.get()).value()) instanceof TitrationBarrelRecipe) {
                TitrationBarrelRecipe titrationBarrelRecipe = (TitrationBarrelRecipe)patt0$temp;
                return titrationBarrelRecipe.getFermentationData();
            }
            PastelCommon.logError("A 'pastel:ferment_randomly' loot function has set an invalid 'fermentation_recipe_id': " + String.valueOf(id) + " It has to match an existing Titration Barrel recipe.");
            return null;
        }, data -> this.fermentation.right().orElse(null));
        if (fermentationData != null) {
            Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
            if (origin != null) {
                BlockPos pos = BlockPos.containing((Position)origin);
                Biome biome = (Biome)context.getLevel().getBiome(pos).value();
                float downfall = ((BiomeAccessor)biome).getClimateSettings().downfall();
                return TitrationBarrelRecipe.getFermentedStack(fermentationData, this.thickness.getInt(context), TimeHelper.secondsFromMinecraftDays(this.daysFermented.getInt(context)), downfall, stack);
            }
            PastelCommon.logError("A 'pastel:ferment_randomly' loot function does not have access to 'origin'.");
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(FermentationData fermentationData, NumberProvider daysFermented, NumberProvider thickness) {
        return FermentRandomlyLootFunction.simpleBuilder(conditions -> new FermentRandomlyLootFunction((List<LootItemCondition>)conditions, fermentationData, daysFermented, thickness));
    }

    public static LootItemConditionalFunction.Builder<?> builder(ResourceLocation fermentationRecipeIdentifier, NumberProvider daysFermented, NumberProvider thickness) {
        return FermentRandomlyLootFunction.simpleBuilder(conditions -> new FermentRandomlyLootFunction((List<LootItemCondition>)conditions, fermentationRecipeIdentifier, daysFermented, thickness));
    }
}

