/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class NightArcheologyModifier
extends LootModifier {
    public static final MapCodec<NightArcheologyModifier> CODEC = RecordCodecBuilder.mapCodec(i -> LootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)ExtraCodecs.RESOURCE_PATH_CODEC.xmap(ResourceLocation::tryParse, ResourceLocation::toString).listOf().fieldOf("targets").forGetter(m -> m.targets), (App)IntProvider.POSITIVE_CODEC.fieldOf("count").forGetter(m -> m.count), (App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)), (App)Codec.BOOL.fieldOf("replace").forGetter(m -> m.replace))).apply((Applicative)i, NightArcheologyModifier::new));
    private final List<ResourceLocation> targets;
    private final IntProvider count;
    private final float chance;
    private final boolean replace;

    protected NightArcheologyModifier(LootItemCondition[] conditionsIn, List<ResourceLocation> targets, IntProvider count, float chance, boolean replace) {
        super(conditionsIn);
        this.targets = targets;
        this.count = count;
        this.chance = chance;
        this.replace = replace;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> original, LootContext lootContext) {
        Item item;
        ResourceLocation id = lootContext.getQueriedLootTableId();
        RandomSource random = lootContext.getRandom();
        Item item2 = item = random.nextFloat() < 0.25f ? PastelBlocks.WEEPING_GALA_SPRIG.asItem() : PastelItems.NIGHTDEW_SPROUT;
        if (!this.targets.contains(id) || random.nextFloat() > this.chance) {
            return original;
        }
        original.add((Object)new ItemStack((ItemLike)item, this.count.sample(random)));
        return original;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

