/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.blocks.CrackedEndPortalFrameBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderEyeItem.class})
public abstract class EnderEyeItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOnBlock(UseOnContext context, CallbackInfoReturnable<InteractionResult> callbackInfoReturnable) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = world.getBlockState(blockPos);
        boolean eyeAdded = false;
        if (blockState.is((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()) && ((CrackedEndPortalFrameBlock.EndPortalFrameEye)((Object)blockState.getValue(CrackedEndPortalFrameBlock.EYE_TYPE))).equals((Object)CrackedEndPortalFrameBlock.EndPortalFrameEye.NONE)) {
            BlockState targetBlockState = (BlockState)blockState.setValue(CrackedEndPortalFrameBlock.EYE_TYPE, (Comparable)((Object)CrackedEndPortalFrameBlock.EndPortalFrameEye.WITH_EYE_OF_ENDER));
            Block.pushEntitiesUp((BlockState)blockState, (BlockState)targetBlockState, (LevelAccessor)world, (BlockPos)blockPos);
            world.setBlock(blockPos, targetBlockState, 2);
            world.updateNeighbourForOutputSignal(blockPos, (Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get());
            eyeAdded = true;
        } else if (blockState.is(Blocks.END_PORTAL_FRAME) && ((Boolean)blockState.getValue((Property)EndPortalFrameBlock.HAS_EYE)).equals(false)) {
            BlockState targetBlockState = (BlockState)blockState.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true));
            Block.pushEntitiesUp((BlockState)blockState, (BlockState)targetBlockState, (LevelAccessor)world, (BlockPos)blockPos);
            world.setBlock(blockPos, targetBlockState, 2);
            world.updateNeighbourForOutputSignal(blockPos, Blocks.END_PORTAL_FRAME);
            eyeAdded = true;
        }
        if (eyeAdded) {
            if (world.isClientSide) {
                callbackInfoReturnable.setReturnValue((Object)InteractionResult.SUCCESS);
            } else {
                context.getItemInHand().shrink(1);
                world.levelEvent(1503, blockPos, 0);
                CrackedEndPortalFrameBlock.checkAndFillEndPortal(world, blockPos);
                callbackInfoReturnable.setReturnValue((Object)InteractionResult.CONSUME);
            }
        }
    }
}

