/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderMan.class})
public abstract class EndermanEntityMixin {
    @Unique
    private final BlockState carriedBlockState = ((Block)PastelBlocks.RADIATING_ENDER.get()).defaultBlockState();

    @Shadow
    @Nullable
    public abstract BlockState getCarriedBlock();

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void init(CallbackInfo info) {
        EnderMan endermanEntity = (EnderMan)this;
        Level world = endermanEntity.getCommandSenderWorld();
        if (world instanceof ServerLevel) {
            RandomSource random = world.random;
            float chance = world.dimension().equals(Level.END) ? PastelCommon.CONFIG.EndermanHoldingEnderTreasureInEndChance : PastelCommon.CONFIG.EndermanHoldingEnderTreasureChance;
            if (random.nextFloat() < chance && endermanEntity.getCarriedBlock() == null) {
                endermanEntity.setCarriedBlock(this.carriedBlockState);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"requiresCustomPersistence"}, cancellable=true)
    public void cannotDespawn(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && this.getCarriedBlock() != null && this.getCarriedBlock().is((Block)PastelBlocks.RADIATING_ENDER.get())) {
            cir.setReturnValue((Object)false);
        }
    }
}

