/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelEnchantments;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class, Player.class})
public abstract class FirstStrikeEnchantmentMixin {
    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public float applyAdditionalFirstStrikeEnchantmentDamage(float amount, DamageSource source) {
        LivingEntity target = (LivingEntity)this;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)entity;
            if (amount != 0.0f && target.getHealth() == target.getMaxHealth()) {
                ItemStack mainHandStack = livingAttacker.getMainHandItem();
                int level = Ench.getLevel((HolderLookup.Provider)livingAttacker.level().registryAccess(), PastelEnchantments.FIRST_STRIKE, mainHandStack);
                if (level > 0) {
                    float additionalDamage = this.getAdditionalFirstStrikeEnchantmentDamage(level);
                    amount += additionalDamage;
                }
            }
        }
        return amount;
    }

    @Unique
    private float getAdditionalFirstStrikeEnchantmentDamage(int level) {
        return PastelCommon.CONFIG.FirstStrikeDamagePerLevel * (float)level;
    }
}

