/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InfestedBlock.class})
public abstract class InfestedBlockMixin {
    @Inject(at={@At(value="HEAD")}, method={"spawnAfterBreak"}, cancellable=true)
    public void onStacksDropped(BlockState state, ServerLevel world, BlockPos pos, ItemStack stack, boolean dropExperience, CallbackInfo ci) {
        if (EnchantmentHelper.hasTag((ItemStack)stack, PastelEnchantmentTags.RESONANT_BLOCK_DROPS)) {
            ci.cancel();
        }
        if (EnchantmentHelper.hasTag((ItemStack)stack, PastelEnchantmentTags.AUTO_KILLS_SILVERFISH)) {
            Silverfish silverfishEntity = (Silverfish)EntityType.SILVERFISH.create((Level)world);
            if (silverfishEntity != null) {
                silverfishEntity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                world.addFreshEntity((Entity)silverfishEntity);
                silverfishEntity.spawnAnim();
                silverfishEntity.kill();
                ExperienceOrb experienceOrbEntity = new ExperienceOrb((Level)world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 10);
                world.addFreshEntity((Entity)experienceOrbEntity);
            }
            ci.cancel();
        }
    }
}

