/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.api.item.DamageAwareItem;
import earth.terrarium.pastel.api.item.GravitableItem;
import earth.terrarium.pastel.api.item.ItemDamageImmunity;
import earth.terrarium.pastel.api.item.TickAwareItem;
import earth.terrarium.pastel.recipe.primordial_fire_burning.PrimordialFireBurningRecipe;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setUnlimitedLifetime();

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"})
    public void ItemEntity(Level world, double x, double y, double z, ItemStack stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        if (EnchantmentHelper.hasTag((ItemStack)stack, PastelEnchantmentTags.PREVENTS_ITEM_DAMAGE)) {
            this.setUnlimitedLifetime();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        Item item;
        ItemEntity thisItemEntity = (ItemEntity)this;
        if (!thisItemEntity.isNoGravity() && thisItemEntity.level().getGameTime() % 8L == 0L) {
            int worldMinY = thisItemEntity.level().getMinBuildHeight();
            if (!thisItemEntity.onGround() && thisItemEntity.position().y() < (double)(worldMinY + 2) && EnchantmentHelper.hasTag((ItemStack)thisItemEntity.getItem(), PastelEnchantmentTags.PREVENTS_ITEM_DAMAGE)) {
                if (thisItemEntity.position().y() < (double)(worldMinY + 1)) {
                    thisItemEntity.setPos(thisItemEntity.position().x, (double)(worldMinY + 1), thisItemEntity.position().z);
                }
                thisItemEntity.setDeltaMovement(0.0, 0.0, 0.0);
                thisItemEntity.setNoGravity(true);
            }
        }
        if ((item = thisItemEntity.getItem().getItem()) instanceof TickAwareItem) {
            TickAwareItem tickingItem = (TickAwareItem)item;
            tickingItem.onItemEntityTicked(thisItemEntity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    public void spectrumItemStackDamageActions(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Item item;
        if (amount > 0.0f && (item = this.getItem().getItem()) instanceof DamageAwareItem) {
            DamageAwareItem damageAwareItem = (DamageAwareItem)item;
            damageAwareItem.onItemEntityDamaged(source, amount, (ItemEntity)this);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void isDamageProof(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Level world;
        ItemEntity thisItemEntity = (ItemEntity)this;
        if (ItemDamageImmunity.isImmuneTo(thisItemEntity.getItem(), source)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
        if (source.is(PastelDamageTypes.PRIMORDIAL_FIRE) && PrimordialFireBurningRecipe.processItemEntity(world = thisItemEntity.level(), thisItemEntity)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFireProof(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (ItemDamageImmunity.isImmuneTo(((ItemEntity)this).getItem(), (TagKey<DamageType>)DamageTypeTags.IS_FIRE)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void doGravityEffects(CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        if (itemEntity.isNoGravity()) {
            return;
        }
        ItemStack stack = itemEntity.getItem();
        Item item = stack.getItem();
        if (item instanceof GravitableItem) {
            GravitableItem gravitableItem = (GravitableItem)item;
            gravitableItem.applyGravity(stack, itemEntity.level(), itemEntity);
        }
    }
}

