/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import earth.terrarium.pastel.api.gui.SlotWithOnClickAction;
import earth.terrarium.pastel.api.item.Preenchanted;
import earth.terrarium.pastel.api.item.TooltipExtensions;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract boolean is(TagKey<Item> var1);

    @Shadow
    public abstract boolean is(Item var1);

    @Shadow
    public abstract Item getItem();

    @Shadow
    @Nullable
    public abstract <T> T remove(DataComponentType<? extends T> var1);

    @Inject(at={@At(value="HEAD")}, method={"overrideStackedOnOther"}, cancellable=true)
    public void onStackClicked(Slot slot, ClickAction clickType, Player player, CallbackInfoReturnable<Boolean> cir) {
        SlotWithOnClickAction slotWithOnClickAction;
        if (slot instanceof SlotWithOnClickAction && (slotWithOnClickAction = (SlotWithOnClickAction)slot).onClicked((ItemStack)this, clickType, player)) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyReturnValue(method={"isDamageableItem"}, at={@At(value="RETURN")})
    public boolean applyIndestructibleEnchantment(boolean original) {
        ItemStack stack = (ItemStack)this;
        return original && !EnchantmentHelper.hasTag((ItemStack)stack, PastelEnchantmentTags.INDESTRUCTIBLE_EFFECT);
    }

    @Inject(at={@At(value="HEAD")}, method={"is(Lnet/minecraft/world/item/Item;)Z"}, cancellable=true)
    private void isSpectrumShears(Item item, CallbackInfoReturnable<Boolean> cir) {
        if (item == Items.SHEARS && this.is((Item)PastelItems.BEDROCK_SHEARS.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isEnchantable()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/ItemEnchantments;isEmpty()Z")}, cancellable=true)
    public void isEnchantable(CallbackInfoReturnable<Boolean> cir) {
        Preenchanted preenchanted;
        ItemStack stack = (ItemStack)this;
        Item item = this.getItem();
        if (item instanceof Preenchanted && (preenchanted = (Preenchanted)item).onlyHasPreEnchantments(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    public void playerTooltip(Item.TooltipContext context, Player player, TooltipFlag type, CallbackInfoReturnable<List<Component>> cir, @Local List<Component> tooltip) {
        ItemStack stack = (ItemStack)this;
        Item item = stack.getItem();
        if (item instanceof TooltipExtensions) {
            TooltipExtensions expanded = (TooltipExtensions)item;
            expanded.appendTooltipWithPlayer(stack, player, tooltip, context);
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="net/minecraft/world/item/TooltipFlag.isAdvanced ()Z", shift=At.Shift.BEFORE, ordinal=1)})
    public void expandTooltipPostDamage(Item.TooltipContext context, Player player, TooltipFlag type, CallbackInfoReturnable<List<Component>> cir, @Local List<Component> tooltip) {
        Item item;
        ItemStack stack = (ItemStack)this;
        MobEffectInstance oilEffect = (MobEffectInstance)stack.get(PastelDataComponentTypes.CONCEALED_EFFECT);
        ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (oilEffect != null && profile != null && player.getUUID().equals(profile.id().orElse(null))) {
            ArrayList subText = new ArrayList();
            PotionContents.addPotionTooltip(List.of(oilEffect), subText::add, (float)1.0f, (float)context.tickRate());
            tooltip.add((Component)Component.translatable((String)"info.pastel.tooltip.adulterated.info").withStyle(s -> s.withColor(4002085)));
            tooltip.add((Component)Component.translatable((String)"info.pastel.tooltip.adulterated.effect", (Object[])new Object[]{subText.getFirst()}).withStyle(s -> s.withColor(4002085).withItalic(Boolean.valueOf(true))));
        }
        if ((item = stack.getItem()) instanceof TooltipExtensions) {
            TooltipExtensions expanded = (TooltipExtensions)item;
            expanded.expandTooltipPostStats(stack, player, tooltip, context);
        }
    }
}

