/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import earth.terrarium.pastel.helpers.enchantments.CloversFavorHelper;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LootItemRandomChanceWithEnchantedBonusCondition.class})
public abstract class RandomChanceWithEnchantedBonusLootConditionMixin {
    @Shadow
    @Final
    private LevelBasedValue enchantedChance;
    @Shadow
    @Final
    private Holder<Enchantment> enchantment;

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"test(Lnet/minecraft/world/level/storage/loot/LootContext;)Z"})
    public boolean applyRareLootEnchantment(boolean original, LootContext context) {
        LivingEntity livingEntity;
        int level;
        Object object;
        if (!original && (object = context.getParamOrNull(LootContextParams.ATTACKING_ENTITY)) instanceof LivingEntity && (level = EnchantmentHelper.getEnchantmentLevel(this.enchantment, (LivingEntity)(livingEntity = (LivingEntity)object))) > 0) {
            float enchantedChanceValue = this.enchantedChance.calculate(level);
            original = context.getRandom().nextFloat() < CloversFavorHelper.rollChance(enchantedChanceValue, (Entity)context.getParamOrNull(LootContextParams.ATTACKING_ENTITY));
        }
        return original;
    }
}

