/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    public Camera camera;

    @Shadow
    private static void fireVertex(PoseStack.Pose entry, VertexConsumer vertices, float x, float y, float z, float u, float v) {
    }

    @Inject(method={"renderFlame"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, Entity entity, Quaternionf rotation, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && PrimordialFireData.isOnPrimordialFire(livingEntity = (LivingEntity)entity)) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderer;render(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", shift=At.Shift.AFTER)})
    public <E extends Entity> void render(E entity, double x, double y, double z, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && PrimordialFireData.isOnPrimordialFire(livingEntity = (LivingEntity)entity)) {
            this.renderPrimordialFire(matrices, vertexConsumers, entity);
        }
    }

    @Unique
    private void renderPrimordialFire(PoseStack matrices, MultiBufferSource vertexConsumers, Entity entity) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(PastelCommon.locate("block/primordial_fire_0"));
        TextureAtlasSprite sprite2 = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(PastelCommon.locate("block/primordial_fire_1"));
        matrices.pushPose();
        float f = entity.getBbWidth() * 1.4f;
        matrices.scale(f, f, f);
        float g = 0.5f;
        float i = entity.getBbHeight() / f;
        float j = 0.0f;
        matrices.mulPose(Axis.YP.rotationDegrees(-this.camera.getYRot()));
        matrices.translate(0.0, 0.0, (double)(-0.3f + (float)((int)i) * 0.02f));
        float k = 0.0f;
        int l = 0;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(Sheets.cutoutBlockSheet());
        PoseStack.Pose entry = matrices.last();
        while (i > 0.0f) {
            TextureAtlasSprite sprite3 = l % 2 == 0 ? sprite : sprite2;
            float m = sprite3.getU0();
            float n = sprite3.getV0();
            float o = sprite3.getU1();
            float p = sprite3.getV1();
            if (l / 2 % 2 == 0) {
                float q = o;
                o = m;
                m = q;
            }
            EntityRenderDispatcherMixin.fireVertex(entry, vertexConsumer, g - 0.0f, 0.0f - j, k, o, p);
            EntityRenderDispatcherMixin.fireVertex(entry, vertexConsumer, -g - 0.0f, 0.0f - j, k, m, p);
            EntityRenderDispatcherMixin.fireVertex(entry, vertexConsumer, -g - 0.0f, 1.4f - j, k, m, n);
            EntityRenderDispatcherMixin.fireVertex(entry, vertexConsumer, g - 0.0f, 1.4f - j, k, o, n);
            i -= 0.45f;
            j -= 0.45f;
            g *= 0.9f;
            k += 0.03f;
            ++l;
        }
        matrices.popPose();
    }
}

