/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import earth.terrarium.pastel.helpers.level.MobEffectHelper;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract Player getCameraPlayer();

    @Shadow
    public abstract void render(GuiGraphics var1, DeltaTracker var2);

    @Shadow
    protected abstract void renderHeart(GuiGraphics var1, Gui.HeartType var2, int var3, int var4, boolean var5, boolean var6, boolean var7);

    @ModifyExpressionValue(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;useFancyGraphics()Z")})
    private boolean disableVignietteInDimension(boolean original) {
        LocalPlayer player = Minecraft.getInstance().player;
        boolean isInDim = player != null && PastelLevels.DIMENSION_KEY.equals((Object)player.level().dimension());
        return !isInDim && original;
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableCrosshairSomnolence(GuiGraphics context, DeltaTracker tickCounter, CallbackInfo ci) {
        float potency = SleepStatusEffect.getSleepScaling((LivingEntity)this.getCameraPlayer());
        if (potency > 0.25f) {
            ci.cancel();
        }
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableHotbarSomnolence(GuiGraphics context, DeltaTracker tickCounter, CallbackInfo ci) {
        float potency = SleepStatusEffect.getSleepScaling((LivingEntity)this.getCameraPlayer());
        if (potency > 0.4f) {
            ci.cancel();
        }
    }

    @Inject(method={"renderPlayerHealth"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableStatusSomnolence(GuiGraphics context, CallbackInfo ci) {
        float potency = SleepStatusEffect.getSleepScaling((LivingEntity)this.getCameraPlayer());
        if (potency > 0.4f) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"renderEffects"}, at=@At(value="INVOKE", target="net/minecraft/client/gui/GuiGraphics.blitSprite (Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=0))
    private ResourceLocation modifyAmbientEffectBackgrounds(ResourceLocation texture, @Local MobEffectInstance effect) {
        return MobEffectHelper.getTextureLocation(texture, effect, MobEffectHelper.RenderType.HUD_AMBIENT);
    }

    @ModifyArg(method={"renderEffects"}, at=@At(value="INVOKE", target="net/minecraft/client/gui/GuiGraphics.blitSprite (Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1))
    private ResourceLocation modifyEffectBackgrounds(ResourceLocation texture, @Local MobEffectInstance effect) {
        return MobEffectHelper.getTextureLocation(texture, effect, MobEffectHelper.RenderType.HUD_DEFAULT);
    }

    @WrapOperation(method={"renderHearts"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIZZZ)V")})
    private void renderDivinityHearts(Gui instance, GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean halfHeart, boolean blinking, Operation<Void> original, @Local(argsOnly=true) Player player) {
        if (player.hasEffect(PastelMobEffects.DIVINITY)) {
            this.renderHeart(guiGraphics, heartType, x, y, true, halfHeart, blinking);
        } else {
            original.call(new Object[]{instance, guiGraphics, heartType, x, y, hardcore, halfHeart, blinking});
        }
    }
}

