/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.c2s_payloads;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record GuidebookHintBoughtPayload(ResourceLocation completionAdvancement, IngredientStack payment) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GuidebookHintBoughtPayload> ID = PastelC2SPackets.makeId("guidebook_hint_bought");
    public static final StreamCodec<RegistryFriendlyByteBuf, GuidebookHintBoughtPayload> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, GuidebookHintBoughtPayload::completionAdvancement, IngredientStack.STREAM_CODEC, GuidebookHintBoughtPayload::payment, GuidebookHintBoughtPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static IPayloadHandler<GuidebookHintBoughtPayload> getPayloadHandler() {
        return (payload, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            for (ItemStack remainder : InventoryHelper.removeIngredientStacksFromInventoryWithRemainders(List.of(payload.payment()), (IItemHandlerModifiable)new PlayerInvWrapper(player.getInventory()))) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerInvWrapper(player.getInventory()), (ItemStack)remainder, (boolean)false);
            }
            Support.grantAdvancementCriterion(player, "hidden/used_tip", "used_tip");
            Support.grantAdvancementCriterion(player, payload.completionAdvancement(), "hint_purchased");
            player.level().playSound((Player)player, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        };
    }
}

