/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.chests.CompactingChestBlockEntity;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CompactingChestStatusUpdatePayload(BlockPos pos, long timeStamp) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CompactingChestStatusUpdatePayload> ID = PastelC2SPackets.makeId("compacting_chest_status_update");
    public static final StreamCodec<FriendlyByteBuf, CompactingChestStatusUpdatePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CompactingChestStatusUpdatePayload::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, CompactingChestStatusUpdatePayload::timeStamp, CompactingChestStatusUpdatePayload::new);

    public static void sendCompactingChestStatusUpdate(CompactingChestBlockEntity chest) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)chest.getLevel()), (ChunkPos)new ChunkPos(chest.getBlockPos()), (CustomPacketPayload)new CompactingChestStatusUpdatePayload(chest.getBlockPos(), chest.craftingTimeStamp), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(CompactingChestStatusUpdatePayload payload, IPayloadContext context) {
        Level level = context.player().level();
        Optional entity = level.getBlockEntity(payload.pos, (BlockEntityType)PastelBlockEntities.COMPACTING_CHEST.get());
        entity.ifPresent(compactingChestBlockEntity -> {
            compactingChestBlockEntity.craftingTimeStamp = payload.timeStamp();
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

