/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.memory.MemoryBlockEntity;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.particle.effect.DynamicParticleEffect;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record PlayMemoryManifestingParticlesPayload(BlockPos pos, int eggColor1, int eggColor2, int amount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayMemoryManifestingParticlesPayload> ID = PastelC2SPackets.makeId("play_memory_manifesting_particles");
    public static final StreamCodec<FriendlyByteBuf, PlayMemoryManifestingParticlesPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PlayMemoryManifestingParticlesPayload::pos, (StreamCodec)ByteBufCodecs.INT, PlayMemoryManifestingParticlesPayload::eggColor1, (StreamCodec)ByteBufCodecs.INT, PlayMemoryManifestingParticlesPayload::eggColor2, (StreamCodec)ByteBufCodecs.INT, PlayMemoryManifestingParticlesPayload::amount, PlayMemoryManifestingParticlesPayload::new);

    public static void playMemoryManifestingParticles(ServerLevel serverWorld, @NotNull BlockPos pos, EntityType<?> entityType, int amount) {
        Tuple<Integer, Integer> eggColors = MemoryBlockEntity.getEggColorsForEntity(entityType);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverWorld, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PlayMemoryManifestingParticlesPayload(pos, (Integer)eggColors.getA(), (Integer)eggColors.getB(), amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayMemoryManifestingParticlesPayload payload, IPayloadContext context) {
        ClientLevel level = (ClientLevel)context.player().level();
        RandomSource random = level.random;
        Vector3f colorVec1 = ColorHelper.colorIntToVec(payload.eggColor1);
        Vector3f colorVec2 = ColorHelper.colorIntToVec(payload.eggColor1);
        BlockPos pos = payload.pos;
        for (int i = 0; i < payload.amount; ++i) {
            int randomLifetime = 30 + random.nextInt(20);
            level.addParticle((ParticleOptions)new DynamicParticleEffect(ColoredCraftingParticleEffect.WHITE.getType(), 0.5f, colorVec1, 1.0f, randomLifetime, false, true), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ(), 0.15 - (double)random.nextFloat() * 0.3, (double)random.nextFloat() * 0.15 + 0.1, 0.15 - (double)random.nextFloat() * 0.3);
            level.addParticle((ParticleOptions)new DynamicParticleEffect(ColoredCraftingParticleEffect.WHITE.getType(), 0.5f, colorVec2, 1.0f, randomLifetime, false, true), (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.15 - (double)random.nextFloat() * 0.3, (double)random.nextFloat() * 0.15 + 0.1, 0.15 - (double)random.nextFloat() * 0.3);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

