/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayParticleAroundBlockSidesPayload(BlockPos pos, int quantity, Vec3 velocity, ParticleOptions particle, Direction[] sides) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayParticleAroundBlockSidesPayload> ID = PastelC2SPackets.makeId("play_particle_around_block_sides");
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayParticleAroundBlockSidesPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PlayParticleAroundBlockSidesPayload::pos, (StreamCodec)ByteBufCodecs.VAR_INT, PlayParticleAroundBlockSidesPayload::quantity, PacketCodecHelper.VEC3D, PlayParticleAroundBlockSidesPayload::velocity, (StreamCodec)ParticleTypes.STREAM_CODEC, PlayParticleAroundBlockSidesPayload::particle, PacketCodecHelper.array(Direction.class, Direction.STREAM_CODEC), PlayParticleAroundBlockSidesPayload::sides, PlayParticleAroundBlockSidesPayload::new);

    public static void playParticleAroundBlockSides(ServerLevel level, int quantity, BlockPos pos, Vec3 velocity, ParticleOptions particleEffect, Predicate<ServerPlayer> sendCheck, Direction ... sides) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)new PlayParticleAroundBlockSidesPayload(pos, quantity, velocity, particleEffect, sides));
        for (ServerPlayer player : level.getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false)) {
            if (sendCheck.test(player)) continue;
            player.connection.send((Packet)packet);
        }
    }

    public static void execute(PlayParticleAroundBlockSidesPayload payload, IPayloadContext context) {
        ParticleHelper.playParticleAroundBlockSides(context.player().level(), payload.particle, payload.pos, payload.sides, payload.quantity, payload.velocity);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

