/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.networking.PastelC2SPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayPedestalCraftingFinishedParticlePayload(BlockPos pedestalPos, ItemStack craftedStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayPedestalCraftingFinishedParticlePayload> ID = PastelC2SPackets.makeId("play_pedestal_crafting_finished_particle");
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayPedestalCraftingFinishedParticlePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PlayPedestalCraftingFinishedParticlePayload::pedestalPos, (StreamCodec)ItemStack.STREAM_CODEC, PlayPedestalCraftingFinishedParticlePayload::craftedStack, PlayPedestalCraftingFinishedParticlePayload::new);

    public static void sendPlayPedestalCraftingFinishedParticle(ServerLevel world, BlockPos pedestalPos, ItemStack craftedStack) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pedestalPos), (CustomPacketPayload)new PlayPedestalCraftingFinishedParticlePayload(pedestalPos, craftedStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayPedestalCraftingFinishedParticlePayload payload, IPayloadContext context) {
        Level level = context.player().level();
        RandomSource random = level.random;
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, payload.craftedStack), (double)payload.pedestalPos.getX() + 0.5, (double)(payload.pedestalPos.getY() + 1), (double)payload.pedestalPos.getZ() + 0.5, 0.15 - (double)random.nextFloat() * 0.3, (double)random.nextFloat() * 0.15 + 0.1, 0.15 - (double)random.nextFloat() * 0.3);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

