/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FireflyParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private double lastVelX;
    private double lastVelZ;
    private int switchTicks = 10;
    private int blinkTicks = 11;
    private float r;
    private float g;
    private float b;

    protected FireflyParticle(ClientLevel clientWorld, double d, double e, double f, double velocityX, double velocityY, double velocityZ, float scaleMultiplier, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
        this.xd = this.random.nextFloat() * 0.1f - 0.05f;
        this.yd = 0.0;
        this.zd = this.random.nextFloat() * 0.1f - 0.05f;
        RandomSource random = clientWorld.getRandom();
        this.gravity = random.nextFloat() * 0.075f - 0.0375f;
        this.hasPhysics = true;
        this.lifetime = 40 + random.nextInt(10);
        this.r = 255.0f;
        this.g = 232.0f;
        this.b = 173.0f;
        int edit = random.nextInt(3);
        if (edit == 0) {
            this.r = Mth.lerpInt((float)random.nextFloat(), (int)255, (int)190);
            this.g *= 0.9f;
            this.b *= 0.9f;
        } else if (edit == 1) {
            this.r *= 0.9f;
            this.g = Mth.lerpInt((float)random.nextFloat(), (int)232, (int)203);
            this.b *= 0.9f;
        } else {
            this.r *= 0.9f;
            this.g *= 0.9f;
            this.b = Mth.lerpInt((float)random.nextFloat(), (int)232, (int)230);
        }
        this.r /= 255.0f;
        this.g /= 255.0f;
        this.b /= 255.0f;
        this.quadSize = 0.025f + random.nextFloat() * 0.375f;
        this.quadSize *= scaleMultiplier;
        this.setColor(this.r, this.g, this.b);
        this.setAlpha(0.0f);
    }

    public void tick() {
        boolean water;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        if (this.blinkTicks <= 10) {
            float delta = (float)Math.abs(this.blinkTicks) / 10.0f;
            this.setColor(Mth.lerp((float)delta, (float)(0.25f * this.r), (float)this.r), Mth.lerp((float)delta, (float)(0.25f * this.g), (float)this.g), Mth.lerp((float)delta, (float)(0.25f * this.b), (float)this.b));
            ++this.blinkTicks;
            this.alpha = Math.min(1.0f, delta + 0.5f);
        }
        if (this.switchTicks < 10) {
            ++this.switchTicks;
        }
        boolean bl = water = !this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isEmpty();
        if (this.age % 10 == 0 && this.random.nextBoolean()) {
            this.switchTicks = 0;
            this.gravity = this.random.nextFloat() * 0.075f - 0.0375f;
            this.lastVelX = this.xd;
            this.lastVelZ = this.zd;
            this.xd = this.random.nextFloat() * 0.1f - 0.05f;
            this.zd = this.random.nextFloat() * 0.1f - 0.05f;
        }
        if (this.age % 13 == 0 && this.random.nextFloat() < 0.334f) {
            this.blinkTicks = -10;
        }
        double flutter = Math.sin((float)this.age / 17.0f) / 18.0;
        double curVelX = Mth.lerp((double)((float)this.switchTicks / 10.0f), (double)this.lastVelX, (double)this.xd);
        double curVelZ = Mth.lerp((double)((float)this.switchTicks / 10.0f), (double)this.lastVelZ, (double)this.zd);
        if (this.onGround || water) {
            curVelX *= (double)0.7f;
            curVelZ *= (double)0.7f;
            this.gravity = this.random.nextFloat() * 0.1334f;
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.move(curVelX, this.yd + flutter, curVelZ);
        if (this.speedUpWhenYMotionIsBlocked && this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.adjustAlpha(water);
    }

    private void adjustAlpha(boolean water) {
        if (this.age <= 5) {
            this.alpha = Mth.clamp((float)((float)this.age / 5.0f), (float)0.0f, (float)1.0f);
            return;
        }
        float ageFade = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, 5) / 5.0f), (float)0.0f, (float)1.0f);
        this.alpha = ageFade < 1.0f ? Math.min(this.alpha, ageFade) : (this.onGround ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.0f, (float)1.0f) : (water ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.5f, (float)1.0f) : Mth.clamp((float)(this.alpha + 0.05f), (float)0.0f, (float)1.0f)));
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new FireflyParticle(clientWorld, d, e, f, 0.0, 0.0, 0.0, 1.0f, this.spriteProvider);
        }
    }
}

