/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.particle.effect.ColoredFluidRisingParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class FixedVelocityParticle
extends TextureSheetParticle {
    protected FixedVelocityParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
        this.gravity = 0.0f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.quadSize *= 0.75f;
        this.hasPhysics = false;
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float tint) {
        float f = ((float)this.age + tint) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(tint);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ColoredSparkleRisingFactory
    implements ParticleProvider<ColoredSparkleRisingParticleEffect> {
        private final SpriteSet spriteProvider;

        public ColoredSparkleRisingFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(ColoredSparkleRisingParticleEffect particleEffect, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            FixedVelocityParticle particle = new FixedVelocityParticle(world, x, y, z, velocityX, velocityY, velocityZ);
            particle.setLifetime((int)(8.0 / (world.random.nextDouble() * 0.8 + 0.2)));
            particle.pickSprite(this.spriteProvider);
            Vector3f color = particleEffect.getColor();
            particle.setColor(color.x, color.y, color.z);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ColoredFluidRisingFactory
    implements ParticleProvider<ColoredFluidRisingParticleEffect> {
        private final SpriteSet spriteProvider;

        public ColoredFluidRisingFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(ColoredFluidRisingParticleEffect particleEffect, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            FixedVelocityParticle particle = new FixedVelocityParticle(world, x, y, z, velocityX, velocityY, velocityZ);
            particle.setLifetime((int)(8.0 / (world.random.nextDouble() * 0.8 + 0.2)));
            particle.pickSprite(this.spriteProvider);
            Vector3f color = particleEffect.getColor();
            particle.setColor(color.x, color.y, color.z);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            FixedVelocityParticle craftingParticle = new FixedVelocityParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            craftingParticle.setLifetime((int)(8.0 / (clientWorld.random.nextDouble() * 0.8 + 0.2)));
            craftingParticle.pickSprite(this.spriteProvider);
            return craftingParticle;
        }
    }
}

