/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LitParticle
extends RisingParticle {
    protected LitParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
        this.quadSize = (this.random.nextFloat() * 0.25f + 0.325f) / 4.0f;
        this.lifetime = (int)Math.round(this.random.triangle(25.0, 15.0));
        this.alpha = 0.0f;
    }

    public void tick() {
        this.adjustAlpha();
        super.tick();
    }

    private void adjustAlpha() {
        if (this.age <= 3) {
            this.alpha = Mth.clamp((float)((float)this.age / 3.0f), (float)0.0f, (float)1.0f);
            return;
        }
        int fadeMarker = this.lifetime / 5 * 2;
        this.alpha = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, fadeMarker) / (float)fadeMarker), (float)0.0f, (float)1.0f);
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            LitParticle particle = new LitParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

