/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RaindropParticle
extends TextureSheetParticle {
    private static final Vec3 VERTICAL = new Vec3(0.0, 1.0, 0.0);
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public RaindropParticle(ClientLevel clientWorld, double d, double e, double f, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f);
        this.pickSprite(spriteProvider);
        this.gravity = 5.25f;
        this.quadSize = 0.1f + this.random.nextFloat() * 0.3125f;
        this.lifetime = 25;
        pos.set(this.x, this.y, this.z);
        Vector3f waterColor = ColorHelper.colorIntToVec(BiomeColors.getAverageWaterColor((BlockAndTintGetter)this.level, (BlockPos)pos));
        this.rCol = waterColor.x;
        this.gCol = waterColor.y;
        this.bCol = waterColor.z;
    }

    public void tick() {
        pos.set(this.x, this.y, this.z);
        Vector3f waterColor = ColorHelper.colorIntToVec(BiomeColors.getAverageWaterColor((BlockAndTintGetter)this.level, (BlockPos)pos));
        this.rCol = waterColor.x;
        this.gCol = waterColor.y;
        this.bCol = waterColor.z;
        if (this.onGround) {
            this.spawnDroplets(0.85f, 4, false);
            this.remove();
            return;
        }
        if (!this.level.getFluidState((BlockPos)pos).isEmpty()) {
            this.spawnDroplets(0.625f, 7, true);
            this.remove();
            return;
        }
        this.adjustAlpha();
        super.tick();
    }

    private void spawnDroplets(float velMult, int drops, boolean water) {
        BlockState state = this.level.getBlockState((BlockPos)pos);
        double spawnY = this.y + (double)0.01f;
        if (water) {
            spawnY = Math.ceil(this.y) - (double)0.05f;
        } else if (state.is((Block)PastelBlocks.FLAYED_EARTH.get())) {
            spawnY = (float)pos.getY() + 1.01f;
        }
        if (this.isAlive()) {
            int spawns = this.random.nextInt(drops) + 1;
            for (int i = 0; i < spawns; ++i) {
                double xVel = (double)this.random.nextFloat() * 0.8 - (double)0.4f;
                double zVel = (double)this.random.nextFloat() * 0.8 - (double)0.4f;
                this.level.addParticle((ParticleOptions)PastelParticleTypes.RAIN_SPLASH, this.x, spawnY, this.z, xVel * (double)velMult, 0.0, zVel * (double)velMult);
            }
            this.level.addParticle((ParticleOptions)PastelParticleTypes.RAIN_RIPPLE, this.x, spawnY, this.z, 0.0, 0.0, 0.0);
        }
    }

    private void adjustAlpha() {
        if (this.age <= 5) {
            this.alpha = Mth.clamp((float)((float)this.age / 5.0f), (float)0.0f, (float)1.0f);
            return;
        }
        float ageFade = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, 5) / 5.0f), (float)0.0f, (float)1.0f);
        this.alpha = Math.min(this.alpha, ageFade);
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.getPosition();
        float f = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float g = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float h = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        double xOffset = this.x - camera.getPosition().x;
        double zOffset = this.z - camera.getPosition().z;
        Quaternionf quaternionf = Axis.YP.rotation((float)Mth.atan2((double)xOffset, (double)zOffset));
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-0.75f, -1.75f, 0.0f), new Vector3f(-0.75f, 1.75f, 0.0f), new Vector3f(0.75f, 1.75f, 0.0f), new Vector3f(0.75f, -1.75f, 0.0f)};
        float i = this.getQuadSize(tickDelta);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f = vector3fs[j];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(i);
            vector3f.add(f, g, h);
        }
        float k = this.getU0();
        float l = this.getU1();
        float m = this.getV0();
        float n = this.getV1();
        int o = this.getLightColor(tickDelta);
        vertexConsumer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(l, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
        vertexConsumer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(l, m).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
        vertexConsumer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(k, m).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
        vertexConsumer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(k, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(o);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new RaindropParticle(clientWorld, d, e, f, this.spriteProvider);
        }
    }
}

