/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.particle.effect.TransmissionParticleEffect;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TransmissionParticle
extends TextureSheetParticle {
    private final PositionSource positionSource;

    public TransmissionParticle(ClientLevel world, double x, double y, double z, PositionSource positionSource, int arrivalInTicks) {
        super(world, x, y, z);
        this.quadSize = 0.3f;
        this.alpha = 0.7f;
        this.lifetime = arrivalInTicks;
        this.positionSource = positionSource;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            Optional optional = this.positionSource.getPosition((Level)this.level);
            if (optional.isEmpty()) {
                this.remove();
            } else {
                int i = this.lifetime - this.age;
                double d = 1.0 / (double)i;
                Vec3 vec3d = (Vec3)optional.get();
                this.x = Mth.lerp((double)d, (double)this.x, (double)vec3d.x());
                this.y = Mth.lerp((double)d, (double)this.y, (double)vec3d.y());
                this.z = Mth.lerp((double)d, (double)this.z, (double)vec3d.z());
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<TransmissionParticleEffect> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(TransmissionParticleEffect particleEffect, ClientLevel world, double x, double y, double z, double g, double h, double i) {
            TransmissionParticle particle = new TransmissionParticle(world, x, y, z, particleEffect.getDestination(), particleEffect.getArrivalInTicks());
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

