/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class CrystallarieumGrownCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("crystallarieum_growing");

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, ItemStack catalystStack) {
        this.trigger(player, conditions -> conditions.matches(world, pos, catalystStack));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, BlockPredicate blockPredicate, ItemPredicate catalystPredicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)BlockPredicate.CODEC.optionalFieldOf("grown_block", (Object)BlockPredicate.Builder.block().build()).forGetter(Conditions::blockPredicate), (App)ItemPredicate.CODEC.optionalFieldOf("used_catalyst", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::catalystPredicate)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ServerLevel world, BlockPos blockPos, ItemStack catalystStack) {
            return this.blockPredicate.matches(world, blockPos) && this.catalystPredicate.test(catalystStack);
        }
    }
}

