/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class EnchanterCraftingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("enchanter_crafting");

    public void trigger(ServerPlayer player, ItemStack itemStack, int experience) {
        this.trigger(player, conditions -> conditions.matches(itemStack, experience));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ItemPredicate itemPredicate, MinMaxBounds.Ints spentExperience) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("item", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::itemPredicate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("spent_experience", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::spentExperience)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack stack, int spentExperience) {
            if (!this.itemPredicate.test(stack)) {
                return false;
            }
            return this.spentExperience.matches(spentExperience);
        }
    }
}

