/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.progression.advancement.ColorPredicate;
import earth.terrarium.pastel.progression.advancement.LongRange;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class InkContainerInteractionCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("ink_container_interaction");

    public void trigger(ServerPlayer player, ItemStack stack, InkStorage storage, InkColor changeColor, long changeAmount) {
        this.trigger(player, conditions -> conditions.matches(stack, storage.getEnergy(), changeColor, changeAmount));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ItemPredicate itemPredicate, Map<InkColor, LongRange> colorRanges, ColorPredicate changeColorPredicate, LongRange changeRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("item", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::itemPredicate), (App)CodecHelper.registryMap(PastelRegistries.INK_COLOR, LongRange.CODEC).forGetter(Conditions::colorRanges), (App)ColorPredicate.CODEC.optionalFieldOf("change_color", (Object)ColorPredicate.ANY).forGetter(Conditions::changeColorPredicate), (App)LongRange.CODEC.optionalFieldOf("change_amount", (Object)LongRange.ANY).forGetter(Conditions::changeRange)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack stack, Map<InkColor, Long> colors, InkColor changeColor, long change) {
            return this.itemPredicate.test(stack) && this.changeRange.test(change) && this.changeColorPredicate.test(changeColor) && this.colorRanges.entrySet().stream().allMatch(entry -> this.colorRanges.get(entry.getKey()).test((Long)colors.get(entry.getKey())));
        }
    }
}

