/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class InkProjectileKillingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("ink_projectile_killing");

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player, List<Entity> piercingKilledEntities) {
        ArrayList list = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        for (Entity entity : piercingKilledEntities) {
            set.add(entity.getType());
            list.add(EntityPredicate.createContext((ServerPlayer)player, (Entity)entity));
        }
        this.trigger(player, conditions -> conditions.matches(list, set.size()));
    }

    public record Conditions(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims, MinMaxBounds.Ints uniqueEntities) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ContextAwarePredicate.CODEC.listOf().optionalFieldOf("victims", List.of()).forGetter(Conditions::victims), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("unique_entity_types", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::uniqueEntities)).apply((Applicative)instance, Conditions::new));

        public boolean matches(Collection<LootContext> victimContexts, int uniqueEntityTypeCount) {
            if (!this.victims.isEmpty()) {
                ArrayList list = Lists.newArrayList(victimContexts);
                for (ContextAwarePredicate extended : this.victims) {
                    boolean bl = false;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        LootContext lootContext = (LootContext)iterator.next();
                        if (!extended.matches(lootContext)) continue;
                        iterator.remove();
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
            }
            return this.uniqueEntities.matches(uniqueEntityTypeCount);
        }
    }
}

