/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class JeopardantKillCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("jeopardant_kill");

    public void trigger(ServerPlayer player, Entity killedEntity) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)killedEntity);
        this.trigger(player, conditions -> conditions.test(player, lootContext));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ContextAwarePredicate killedEntity, MinMaxBounds.Ints health) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("killed_entity", (Object)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0])).forGetter(Conditions::killedEntity), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("health", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::health)).apply((Applicative)instance, Conditions::new));

        public boolean test(ServerPlayer player, LootContext killedEntityContext) {
            return this.killedEntity.matches(killedEntityContext) && this.health.matches(Math.round(player.getHealth()));
        }
    }
}

