/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class MemoryManifestingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("memory_manifesting");

    public void trigger(ServerPlayer player, Entity manifestedEntity) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)manifestedEntity);
        this.trigger(player, conditions -> conditions.matches(lootContext));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ContextAwarePredicate manifestedEntity) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("manifested_entity", (Object)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0])).forGetter(Conditions::manifestedEntity)).apply((Applicative)instance, Conditions::new));

        public boolean matches(LootContext context) {
            return this.manifestedEntity.matches(context);
        }
    }
}

