/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeType;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PastelNetworkCreationCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("pastel_network_creation");

    public void trigger(ServerPlayer player, ServerPastelNetwork network) {
        this.trigger(player, conditions -> conditions.matches(network.getLoadedNodes(PastelNodeType.CONNECTION).size(), network.getLoadedNodes(PastelNodeType.PROVIDER).size(), network.getLoadedNodes(PastelNodeType.STORAGE).size(), network.getLoadedNodes(PastelNodeType.SENDER).size(), network.getLoadedNodes(PastelNodeType.GATHER).size(), network.getLoadedNodes(PastelNodeType.BUFFER).size()));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints totalNodes, MinMaxBounds.Ints connectionNodes, MinMaxBounds.Ints providerNodes, MinMaxBounds.Ints storageNodes, MinMaxBounds.Ints senderNodes, MinMaxBounds.Ints gatherNodes, MinMaxBounds.Ints bufferNodes) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("total_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::totalNodes), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("connection_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::connectionNodes), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("provider_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::providerNodes), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("storage_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::storageNodes), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("sender_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::senderNodes), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("gather_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::gatherNodes), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("buffer_nodes", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::bufferNodes)).apply((Applicative)instance, Conditions::new));

        public boolean matches(int connectionNodes, int providerNodes, int storageNodes, int senderNodes, int gatherNodes, int bufferNodes) {
            return this.totalNodes.matches(connectionNodes + providerNodes + storageNodes + senderNodes + gatherNodes) && this.connectionNodes.matches(connectionNodes) && this.providerNodes.matches(providerNodes) && this.storageNodes.matches(storageNodes) && this.senderNodes.matches(senderNodes) && this.gatherNodes.matches(gatherNodes) && this.bufferNodes.matches(bufferNodes);
        }
    }
}

