/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public class PotionWorkshopBrewingCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("potion_workshop_brewing");

    public void trigger(ServerPlayer player, ItemStack itemStack, int brewedCount) {
        this.trigger(player, conditions -> {
            List effects;
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof InkPoweredPotionFillable) {
                InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)patt0$temp;
                effects = inkPoweredPotionFillable.getVanillaEffects(itemStack);
            } else {
                PotionContents potionComponent = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                effects = potionComponent.customEffects();
            }
            int highestAmplifier = 0;
            int longestDuration = 0;
            for (MobEffectInstance instance : effects) {
                if (instance.getAmplifier() > highestAmplifier) {
                    highestAmplifier = instance.getAmplifier();
                }
                if (instance.getDuration() <= longestDuration) continue;
                longestDuration = instance.getDuration();
            }
            ArrayList<MobEffect> uniqueEffects = new ArrayList<MobEffect>();
            for (MobEffectInstance instance : effects) {
                if (uniqueEffects.contains(instance.getEffect().value())) continue;
                uniqueEffects.add((MobEffect)instance.getEffect().value());
            }
            return conditions.matches(itemStack, effects, brewedCount, highestAmplifier, longestDuration, effects.size(), uniqueEffects.size());
        });
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, ItemPredicate itemPredicate, MobEffectsPredicate statusEffectsPredicate, MinMaxBounds.Ints brewedCountRange, MinMaxBounds.Ints maxAmplifierRange, MinMaxBounds.Ints maxDurationRange, MinMaxBounds.Ints effectCountRange, MinMaxBounds.Ints uniqueEffectCountRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("item", (Object)ItemPredicate.Builder.item().build()).forGetter(Conditions::itemPredicate), (App)MobEffectsPredicate.CODEC.optionalFieldOf("effects", (Object)new MobEffectsPredicate(Map.of())).forGetter(Conditions::statusEffectsPredicate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("brewed_count", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::brewedCountRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("highest_amplifier", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::maxAmplifierRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("longest_duration", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::maxDurationRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("effect_count", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::effectCountRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("unique_effect_count", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::uniqueEffectCountRange)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack stack, List<MobEffectInstance> effects, int brewedCount, int maxAmplifier, int maxDuration, int effectCount, int uniqueEffectCount) {
            if (this.brewedCountRange.matches(brewedCount) && this.maxAmplifierRange.matches(maxAmplifier) && this.maxDurationRange.matches(maxDuration) && this.effectCountRange.matches(effectCount) && this.uniqueEffectCountRange.matches(uniqueEffectCount) && this.itemPredicate.test(stack)) {
                HashMap<Holder, MobEffectInstance> effectMap = new HashMap<Holder, MobEffectInstance>();
                for (MobEffectInstance instance : effects) {
                    if (effectMap.containsKey(instance.getEffect())) continue;
                    effectMap.put(instance.getEffect(), instance);
                }
                return this.statusEffectsPredicate.matches(effectMap);
            }
            return false;
        }
    }
}

