/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.anvil_crushing;

import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.recipe.anvil_crushing.AnvilCrushingRecipe;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AnvilCrusher {
    public static void crush(ItemEntity itemEntity, float damageAmount) {
        ItemStack thisItemStack = itemEntity.getItem();
        Level world = itemEntity.level();
        SingleRecipeInput inventory = new SingleRecipeInput(thisItemStack);
        Optional optionalAnvilCrushingRecipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.ANVIL_CRUSHING, (RecipeInput)inventory, world);
        if (optionalAnvilCrushingRecipe.isPresent()) {
            AnvilCrushingRecipe recipe = (AnvilCrushingRecipe)((RecipeHolder)optionalAnvilCrushingRecipe.get()).value();
            int itemStackAmount = itemEntity.getItem().getCount();
            int crushingInputAmount = Math.min(itemStackAmount, (int)(recipe.getCrushedItemsPerPointOfDamage() * damageAmount));
            if (crushingInputAmount > 0) {
                SoundEvent soundEvent;
                Vec3 position = itemEntity.position();
                ItemStack crushingOutput = recipe.getResultItem((HolderLookup.Provider)world.registryAccess()).copy();
                Vec3 pos = itemEntity.position();
                int remainingItemStackAmount = itemStackAmount - crushingInputAmount;
                if (remainingItemStackAmount > 0) {
                    thisItemStack.setCount(remainingItemStackAmount);
                } else {
                    itemEntity.remove(Entity.RemovalReason.DISCARDED);
                }
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, pos, crushingOutput, crushingOutput.getCount() * crushingInputAmount, Vec3.ZERO, false, null);
                float craftingXPFloat = recipe.getExperience() * (float)crushingInputAmount;
                int craftingXP = Support.chanceRound(craftingXPFloat, world.random);
                if (craftingXP > 0) {
                    ExperienceOrb experienceOrbEntity = new ExperienceOrb(world, position.x, position.y, position.z, craftingXP);
                    world.addFreshEntity((Entity)experienceOrbEntity);
                }
                if ((soundEvent = recipe.getSoundEvent()) != null) {
                    float randomVolume = 1.0f + world.getRandom().nextFloat() * 0.2f;
                    float randomPitch = 0.9f + world.getRandom().nextFloat() * 0.2f;
                    world.playSound(null, position.x, position.y, position.z, soundEvent, SoundSource.PLAYERS, randomVolume, randomPitch);
                }
                PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((ServerLevel)world, position, recipe.getParticleEffect(), recipe.getParticleCount(), Vec3.ZERO);
            }
        }
    }
}

