/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.anvil_crushing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class AnvilCrushingRecipe
extends GatedPastelRecipe<SingleRecipeInput> {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final float crushedItemsPerPointOfDamage;
    protected final float experience;
    protected final Optional<ResourceLocation> particleEffectIdentifier;
    protected final int particleCount;
    protected final ResourceLocation soundEvent;

    public AnvilCrushingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, Ingredient ingredient, ItemStack result, float crushedItemsPerPointOfDamage, float experience, Optional<ResourceLocation> particleEffectIdentifier, int particleCount, ResourceLocation soundEventIdentifier) {
        super(group, secret, requiredAdvancementIdentifier);
        this.ingredient = ingredient;
        this.result = result;
        this.crushedItemsPerPointOfDamage = crushedItemsPerPointOfDamage;
        this.experience = experience;
        this.particleEffectIdentifier = particleEffectIdentifier;
        this.particleCount = particleCount;
        this.soundEvent = soundEventIdentifier;
        if (requiredAdvancementIdentifier.isPresent()) {
            this.registerInToastManager(this.getType(), this);
        }
    }

    public boolean matches(SingleRecipeInput input, Level world) {
        return this.ingredient.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registryLookup) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.result;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Blocks.ANVIL);
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.ANVIL_CRUSHING_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.ANVIL_CRUSHING;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "anvil_crushing";
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.ingredient);
        return defaultedList;
    }

    public float getCrushedItemsPerPointOfDamage() {
        return this.crushedItemsPerPointOfDamage;
    }

    public SoundEvent getSoundEvent() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.soundEvent);
    }

    public ParticleOptions getParticleEffect() {
        return (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get((ResourceLocation)this.particleEffectIdentifier.orElse(null));
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public float getExperience() {
        return this.experience;
    }

    public static class Serializer
    implements RecipeSerializer<AnvilCrushingRecipe> {
        private static final MapCodec<AnvilCrushingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.FLOAT.fieldOf("crushedItemsPerPointOfDamage").forGetter(recipe -> Float.valueOf(recipe.crushedItemsPerPointOfDamage)), (App)Codec.FLOAT.fieldOf("experience").forGetter(recipe -> Float.valueOf(recipe.experience)), (App)ResourceLocation.CODEC.optionalFieldOf("particleEffectIdentifier").forGetter(recipe -> recipe.particleEffectIdentifier), (App)Codec.INT.optionalFieldOf("particleCount", (Object)1).forGetter(recipe -> recipe.particleCount), (App)ResourceLocation.CODEC.fieldOf("soundEventIdentifier").forGetter(recipe -> recipe.soundEvent)).apply((Applicative)instance, AnvilCrushingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AnvilCrushingRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, c -> c.group, ByteBufCodecs.BOOL, c -> c.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, ItemStack.STREAM_CODEC, c -> c.result, ByteBufCodecs.FLOAT, c -> Float.valueOf(c.crushedItemsPerPointOfDamage), ByteBufCodecs.FLOAT, c -> Float.valueOf(c.experience), ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.particleEffectIdentifier, ByteBufCodecs.VAR_INT, c -> c.particleCount, ResourceLocation.STREAM_CODEC, c -> c.soundEvent, AnvilCrushingRecipe::new);

        public MapCodec<AnvilCrushingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AnvilCrushingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

