/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.enchanter;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntity;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.recipe.RecipeScaling;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchanterRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchantmentUpgradeRecipe
extends EnchanterRecipe {
    protected final Either<Holder<Enchantment>, ResourceKey<Enchantment>> either;
    protected final int levelCap;
    protected final Ingredient bulkItem;
    protected final RecipeScaling.ScalingData itemScaling;
    protected final RecipeScaling.ScalingData xpScaling;
    protected final NonNullList<Ingredient> inputs;
    protected final ItemStack output;

    public EnchantmentUpgradeRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, Either<Holder<Enchantment>, ResourceKey<Enchantment>> enchantmentEntry, int levelCap, Ingredient bulkItem, RecipeScaling.ScalingData xpScaling, RecipeScaling.ScalingData itemScaling) {
        super(group, secret, requiredAdvancementIdentifier);
        this.either = enchantmentEntry;
        this.levelCap = levelCap;
        this.bulkItem = bulkItem;
        this.itemScaling = itemScaling;
        this.xpScaling = xpScaling;
        NonNullList inputs = NonNullList.withSize((int)2, (Object)Ingredient.EMPTY);
        if (enchantmentEntry.left().isPresent()) {
            Holder enchantment = (Holder)enchantmentEntry.left().get();
            int baseMax = ((Enchantment)enchantment.value()).getMaxLevel();
            if (levelCap < baseMax) {
                throw new JsonParseException("Level Cap cannot be lower than the Enchantment's base level (levelCap " + levelCap + "< enchantment's" + baseMax + ")");
            }
            ItemStack ingredientStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            ingredientStack.enchant(enchantment, levelCap - 1);
            inputs.set(0, (Object)Ingredient.of((ItemStack[])new ItemStack[]{ingredientStack}));
            inputs.set(1, (Object)bulkItem);
            this.inputs = inputs;
            ItemStack outputStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            outputStack.enchant((Holder)enchantmentEntry.left().get(), levelCap);
            this.output = outputStack;
        } else {
            this.inputs = NonNullList.create();
            this.output = ItemStack.EMPTY;
        }
    }

    public boolean matches(RecipeInput inv, Level level) {
        ItemStack center = inv.getItem(0);
        if (this.either.left().isEmpty()) {
            throw new UnsupportedOperationException("Attempted to match a datagen enchantment upgrade");
        }
        Holder enchantment = (Holder)this.either.left().get();
        if (!((Ingredient)this.inputs.getFirst()).test(center)) {
            return false;
        }
        ItemEnchantments enchantments = (ItemEnchantments)center.get(DataComponents.STORED_ENCHANTMENTS);
        if (enchantments == null) {
            return false;
        }
        int bookLevel = enchantments.getLevel(enchantment);
        if (!enchantments.keySet().contains(enchantment) || bookLevel >= this.levelCap) {
            return false;
        }
        int requiredXp = this.xpScaling.apply(bookLevel);
        Integer availableXp = Optional.ofNullable((ExperienceHandler)inv.getItem(1).getCapability(PastelCapabilities.Misc.XP, (Object)level.registryAccess())).map(ExperienceHandler::getStoredAmount).orElse(0);
        if (availableXp < requiredXp) {
            return false;
        }
        int bulkInput = 0;
        for (int i = 2; i < 10; ++i) {
            ItemStack currentStack = inv.getItem(i);
            if (currentStack.isEmpty()) continue;
            ItemStack slotStack = inv.getItem(i);
            if (this.bulkItem.test(slotStack)) {
                bulkInput += slotStack.getCount();
                continue;
            }
            return false;
        }
        return bulkInput >= this.itemScaling.apply(bookLevel);
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider drm) {
        ItemStack stack = inv.getItem(0).copy();
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int curLevel = ((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel(this.getEnchantment());
        Ench.addOrUpgradeEnchantment(stack, this.getEnchantment(), curLevel + 1, false, false);
        return stack;
    }

    @Override
    public void consumeIngredients(EnchanterBlockEntity enchanter, HolderLookup.Provider lookup, double scaling) {
        if (scaling == 0.0) {
            PastelCommon.logWarning("Performed enchantment upgrade recipe with scaling of 0. This is concerning!");
        }
        int itemDrain = this.itemScaling.apply(scaling);
        int xpDrain = this.xpScaling.apply(scaling);
        FriendlyStackHandler inv = enchanter.getInputs();
        for (int i = 2; i < 10; ++i) {
            if (this.bulkItem.test(inv.getStackInSlot(i))) {
                itemDrain -= inv.extractItem(i, itemDrain, false).getCount();
            }
            if (itemDrain == 0) break;
        }
        Optional.ofNullable((ExperienceHandler)inv.getStackInSlot(1).getCapability(PastelCapabilities.Misc.XP, (Object)lookup)).map(storage -> storage.extract(xpDrain, false));
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.ENCHANTER.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.ENCHANTMENT_UPGRADE_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.ENCHANTMENT_UPGRADE;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return EnchanterCraftingRecipe.UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "enchantment_upgrade";
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public Item getBulkItem() {
        ItemStack[] match = this.bulkItem.getItems();
        if (match != null && match.length > 0) {
            return this.bulkItem.getItems()[0].getItem();
        }
        return Items.AIR;
    }

    public int getBaseXPCost() {
        return this.xpScaling.apply(1.0);
    }

    public int getBaseItemCost() {
        return this.itemScaling.apply(1.0);
    }

    public RecipeScaling.ScalingData getXpScaling() {
        return this.xpScaling;
    }

    public RecipeScaling.ScalingData getItemScaling() {
        return this.itemScaling;
    }

    @Override
    public int getCraftingTime(double scaling) {
        return this.itemScaling.apply(scaling);
    }

    @Override
    public boolean noDiscounts() {
        return true;
    }

    public Holder<Enchantment> getEnchantment() {
        if (this.either.left().isEmpty()) {
            throw new UnsupportedOperationException("Attempted to match a datagen enchantment upgrade");
        }
        return (Holder)this.either.left().get();
    }

    public int getLevelCap() {
        return this.levelCap;
    }

    public boolean isInNormalRange(int level) {
        if (this.either.left().isEmpty()) {
            throw new UnsupportedOperationException("Attempted to match a datagen enchantment upgrade");
        }
        return level < ((Enchantment)((Holder)this.either.left().get()).value()).getMaxLevel();
    }

    public static class Serializer
    implements RecipeSerializer<EnchantmentUpgradeRecipe> {
        public static final MapCodec<EnchantmentUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Codec.either((Codec)Enchantment.CODEC, (Codec)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT)).fieldOf("enchantment").forGetter(c -> c.either), (App)Codec.INT.fieldOf("level_cap").forGetter(recipe -> recipe.levelCap), (App)Ingredient.CODEC_NONEMPTY.fieldOf("bulk_item").forGetter(recipe -> recipe.bulkItem), (App)RecipeScaling.CODEC.fieldOf("xp_scaling").forGetter(recipe -> recipe.xpScaling), (App)RecipeScaling.CODEC.fieldOf("item_scaling").forGetter(recipe -> recipe.itemScaling)).apply((Applicative)i, EnchantmentUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentUpgradeRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, ByteBufCodecs.either((StreamCodec)Enchantment.STREAM_CODEC, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.ENCHANTMENT)), c -> c.either, ByteBufCodecs.VAR_INT, recipe -> recipe.levelCap, Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.bulkItem, RecipeScaling.STREAM_CODEC, recipe -> recipe.xpScaling, RecipeScaling.STREAM_CODEC, recipe -> recipe.itemScaling, EnchantmentUpgradeRecipe::new);

        public MapCodec<EnchantmentUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnchantmentUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

