/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.pedestal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;

public class RawShapedPedestalRecipe {
    public static final MapCodec<RawShapedPedestalRecipe> CODEC = Data.CODEC.flatXmap(RawShapedPedestalRecipe::fromData, recipe -> recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, RawShapedPedestalRecipe> STREAM_CODEC = StreamCodec.ofMember(RawShapedPedestalRecipe::writeToBuf, RawShapedPedestalRecipe::readFromBuf);
    private final int width;
    private final int height;
    private final NonNullList<IngredientStack> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public RawShapedPedestalRecipe(int width, int height, NonNullList<IngredientStack> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.data = data;
        int i = 0;
        for (IngredientStack ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ++i;
        }
        this.ingredientCount = i;
        this.symmetrical = Util.isSymmetrical((int)width, (int)height, ingredients);
    }

    public static RawShapedPedestalRecipe create(Map<Character, IngredientStack> key, String ... pattern) {
        return RawShapedPedestalRecipe.create(key, List.of(pattern));
    }

    public static RawShapedPedestalRecipe create(Map<Character, IngredientStack> key, List<String> pattern) {
        Data data = new Data(key, pattern);
        return (RawShapedPedestalRecipe)RawShapedPedestalRecipe.fromData(data).getOrThrow();
    }

    private static DataResult<RawShapedPedestalRecipe> fromData(Data data) {
        String[] strings = RawShapedPedestalRecipe.removePadding(data.pattern);
        int i = strings[0].length();
        int j = strings.length;
        NonNullList defaultedList = NonNullList.withSize((int)(i * j), (Object)IngredientStack.EMPTY);
        CharArraySet charSet = new CharArraySet(data.key.keySet());
        for (int k = 0; k < strings.length; ++k) {
            String string = strings[k];
            for (int l = 0; l < string.length(); ++l) {
                IngredientStack ingredient;
                char c = string.charAt(l);
                IngredientStack ingredientStack = ingredient = c == ' ' ? IngredientStack.EMPTY : data.key.get(Character.valueOf(c));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                }
                charSet.remove(c);
                defaultedList.set(l + i * k, (Object)ingredient);
            }
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> RawShapedPedestalRecipe.lambda$fromData$4((CharSet)charSet));
        }
        return DataResult.success((Object)new RawShapedPedestalRecipe(i, j, (NonNullList<IngredientStack>)defaultedList, Optional.of(data)));
    }

    static String[] removePadding(List<String> pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.size(); ++m) {
            String string = pattern.get(m);
            i = Math.min(i, RawShapedPedestalRecipe.findFirstSymbol(string));
            int n = RawShapedPedestalRecipe.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.size() == l) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = pattern.get(o + k).substring(i, j + 1);
        }
        return strings;
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String line) {
        int i;
        for (i = line.length() - 1; i >= 0 && line.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean matches(CraftingInput input) {
        if (input.ingredientCount() != this.ingredientCount) {
            return false;
        }
        if (input.width() == this.width && input.height() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            return this.matches(input, false);
        }
        return false;
    }

    public boolean matches(CraftingInput input, boolean mirrored) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                ItemStack itemStack;
                IngredientStack ingredient = mirrored ? (IngredientStack)this.ingredients.get(this.width - j - 1 + i * this.width) : (IngredientStack)this.ingredients.get(j + i * this.width);
                if (ingredient.test(itemStack = input.getItem(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeToBuf(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.width);
        buf.writeVarInt(this.height);
        for (IngredientStack ingredient : this.ingredients) {
            IngredientStack.STREAM_CODEC.encode((Object)buf, (Object)ingredient);
        }
    }

    private static RawShapedPedestalRecipe readFromBuf(RegistryFriendlyByteBuf buf) {
        int i = buf.readVarInt();
        int j = buf.readVarInt();
        NonNullList defaultedList = NonNullList.withSize((int)(i * j), (Object)IngredientStack.EMPTY);
        defaultedList.replaceAll(ingredient -> (IngredientStack)IngredientStack.STREAM_CODEC.decode((Object)buf));
        return new RawShapedPedestalRecipe(i, j, (NonNullList<IngredientStack>)defaultedList, Optional.empty());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public NonNullList<IngredientStack> getIngredients() {
        return this.ingredients;
    }

    private static /* synthetic */ String lambda$fromData$4(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public record Data(Map<Character, IngredientStack> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
            if (pattern.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)pattern.getFirst()).length();
            for (String string : pattern) {
                if (i == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)pattern);
        }, Function.identity());
        private static final Codec<Character> KEY_ENTRY_CODEC = Codec.STRING.comapFlatMap(keyEntry -> {
            if (keyEntry.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.strictUnboundedMap(KEY_ENTRY_CODEC, IngredientStack.CODEC).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)i, Data::new));
    }
}

