/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.potion_workshop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.potion_workshop.PotionRecipeEffect;
import java.awt.Color;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;

public record PotionMod(int flatDurationBonusTicks, float flatPotencyBonus, float durationMultiplier, float potencyMultiplier, float flatPotencyBonusPositiveEffects, float flatPotencyBonusNegativeEffects, int flatDurationBonusPositiveEffects, int flatDurationBonusNegativeEffects, float additionalRandomPositiveEffectCount, float additionalRandomNegativeEffectCount, float chanceToAddLastEffect, float lastEffectDurationMultiplier, float lastEffectPotencyMultiplier, float yield, int additionalDrinkDurationTicks, PotionFlags flags) {
    public static final Codec<PotionMod> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("flat_duration_bonus_ticks", (Object)0).forGetter(PotionMod::flatDurationBonusTicks), (App)Codec.FLOAT.optionalFieldOf("flat_potency_bonus", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::flatPotencyBonus), (App)Codec.FLOAT.optionalFieldOf("duration_multiplier", (Object)Float.valueOf(1.0f)).forGetter(PotionMod::durationMultiplier), (App)Codec.FLOAT.optionalFieldOf("potency_multiplier", (Object)Float.valueOf(1.0f)).forGetter(PotionMod::potencyMultiplier), (App)Codec.FLOAT.optionalFieldOf("flat_potency_bonus_positive_effects", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::flatPotencyBonusPositiveEffects), (App)Codec.FLOAT.optionalFieldOf("flat_potency_bonus_negative_effects", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::flatPotencyBonusNegativeEffects), (App)Codec.INT.optionalFieldOf("flat_duration_bonus_ticks_positive_effects", (Object)0).forGetter(PotionMod::flatDurationBonusPositiveEffects), (App)Codec.INT.optionalFieldOf("flat_duration_bonus_ticks_negative_effects", (Object)0).forGetter(PotionMod::flatDurationBonusNegativeEffects), (App)Codec.FLOAT.optionalFieldOf("additional_random_positive_effect_count", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::additionalRandomPositiveEffectCount), (App)Codec.FLOAT.optionalFieldOf("additional_random_negative_effect_count", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::additionalRandomNegativeEffectCount), (App)Codec.FLOAT.optionalFieldOf("chance_to_add_last_effect", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::chanceToAddLastEffect), (App)Codec.FLOAT.optionalFieldOf("last_effect_duration_modifier", (Object)Float.valueOf(1.0f)).forGetter(PotionMod::lastEffectDurationMultiplier), (App)Codec.FLOAT.optionalFieldOf("last_effect_potency_modifier", (Object)Float.valueOf(1.0f)).forGetter(PotionMod::lastEffectPotencyMultiplier), (App)Codec.FLOAT.optionalFieldOf("flat_yield_bonus", (Object)Float.valueOf(0.0f)).forGetter(PotionMod::yield), (App)Codec.INT.optionalFieldOf("additional_drink_duration_ticks", (Object)0).forGetter(PotionMod::additionalDrinkDurationTicks), (App)PotionFlags.CODEC.forGetter(PotionMod::flags)).apply((Applicative)i, PotionMod::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionMod> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.VAR_INT, PotionMod::flatDurationBonusTicks, ByteBufCodecs.FLOAT, PotionMod::flatPotencyBonus, ByteBufCodecs.FLOAT, PotionMod::durationMultiplier, ByteBufCodecs.FLOAT, PotionMod::potencyMultiplier, ByteBufCodecs.FLOAT, PotionMod::flatPotencyBonusPositiveEffects, ByteBufCodecs.FLOAT, PotionMod::flatPotencyBonusNegativeEffects, ByteBufCodecs.VAR_INT, PotionMod::flatDurationBonusPositiveEffects, ByteBufCodecs.VAR_INT, PotionMod::flatDurationBonusNegativeEffects, ByteBufCodecs.FLOAT, PotionMod::additionalRandomPositiveEffectCount, ByteBufCodecs.FLOAT, PotionMod::additionalRandomNegativeEffectCount, ByteBufCodecs.FLOAT, PotionMod::chanceToAddLastEffect, ByteBufCodecs.FLOAT, PotionMod::lastEffectDurationMultiplier, ByteBufCodecs.FLOAT, PotionMod::lastEffectPotencyMultiplier, ByteBufCodecs.FLOAT, PotionMod::yield, ByteBufCodecs.VAR_INT, PotionMod::additionalDrinkDurationTicks, PotionFlags.STREAM_CODEC, PotionMod::flags, PotionMod::new);

    public int getColor(RandomSource random) {
        return this.flags.randomColor ? Color.getHSBColor(random.nextFloat(), 0.7f, 0.9f).getRGB() : (this.flags.unidentifiable ? 0x2F2F2F : -1);
    }

    public record PotionFlags(boolean makeSplashing, boolean makeLingering, boolean noParticles, boolean unidentifiable, boolean makeEffectsPositive, boolean potentDecreasingEffect, boolean negateDecreasingDuration, boolean randomColor, boolean incurable, List<Tuple<PotionRecipeEffect, Float>> additionalEffects) {
        private static final Codec<Tuple<PotionRecipeEffect, Float>> ENTRY_CODEC = RecordCodecBuilder.create(i -> i.group((App)PotionRecipeEffect.CODEC.forGetter(Tuple::getA), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Tuple::getB)).apply((Applicative)i, Tuple::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, Tuple<PotionRecipeEffect, Float>> ENTRY_PACKET_CODEC = PacketCodecHelper.pair(PotionRecipeEffect.STREAM_CODEC, ByteBufCodecs.FLOAT);
        public static final MapCodec<PotionFlags> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("make_splashing", (Object)false).forGetter(PotionFlags::makeSplashing), (App)Codec.BOOL.optionalFieldOf("make_lingering", (Object)false).forGetter(PotionFlags::makeLingering), (App)Codec.BOOL.optionalFieldOf("no_particles", (Object)false).forGetter(PotionFlags::noParticles), (App)Codec.BOOL.optionalFieldOf("unidentifiable", (Object)false).forGetter(PotionFlags::unidentifiable), (App)Codec.BOOL.optionalFieldOf("make_effects_positive", (Object)false).forGetter(PotionFlags::makeEffectsPositive), (App)Codec.BOOL.optionalFieldOf("potent_decreasing_effect", (Object)false).forGetter(PotionFlags::potentDecreasingEffect), (App)Codec.BOOL.optionalFieldOf("negate_decreasing_duration", (Object)false).forGetter(PotionFlags::negateDecreasingDuration), (App)Codec.BOOL.optionalFieldOf("random_color", (Object)false).forGetter(PotionFlags::randomColor), (App)Codec.BOOL.optionalFieldOf("incurable", (Object)false).forGetter(PotionFlags::incurable), (App)ENTRY_CODEC.listOf().optionalFieldOf("additional_effects", List.of()).forGetter(PotionFlags::additionalEffects)).apply((Applicative)i, PotionFlags::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionFlags> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.BOOL, PotionFlags::makeSplashing, ByteBufCodecs.BOOL, PotionFlags::makeLingering, ByteBufCodecs.BOOL, PotionFlags::noParticles, ByteBufCodecs.BOOL, PotionFlags::unidentifiable, ByteBufCodecs.BOOL, PotionFlags::makeEffectsPositive, ByteBufCodecs.BOOL, PotionFlags::potentDecreasingEffect, ByteBufCodecs.BOOL, PotionFlags::negateDecreasingDuration, ByteBufCodecs.BOOL, PotionFlags::randomColor, ByteBufCodecs.BOOL, PotionFlags::incurable, ENTRY_PACKET_CODEC.apply(ByteBufCodecs.list()), PotionFlags::additionalEffects, PotionFlags::new);
    }

    public static class Builder {
        public int flatDurationBonusTicks = 0;
        public float flatPotencyBonus = 0.0f;
        public float durationMultiplier = 1.0f;
        public float potencyMultiplier = 1.0f;
        public float flatPotencyBonusPositiveEffects = 0.0f;
        public float flatPotencyBonusNegativeEffects = 0.0f;
        public int flatDurationBonusPositiveEffects = 0;
        public int flatDurationBonusNegativeEffects = 0;
        public float additionalRandomPositiveEffectCount = 0.0f;
        public float additionalRandomNegativeEffectCount = 0.0f;
        public float chanceToAddLastEffect = 0.0f;
        public float lastEffectDurationMultiplier = 1.0f;
        public float lastEffectPotencyMultiplier = 1.0f;
        public float yield = 0.0f;
        public int additionalDrinkDurationTicks = 0;
        public PotionFlags flags = new PotionFlags(false, false, false, false, false, false, false, false, false, List.of());

        public Builder() {
        }

        public Builder(PotionMod potionMod) {
            this.combine(potionMod);
        }

        public Builder combine(PotionMod potionMod) {
            this.flatDurationBonusTicks += potionMod.flatDurationBonusTicks;
            this.flatPotencyBonus += potionMod.flatPotencyBonus;
            this.durationMultiplier += potionMod.durationMultiplier - 1.0f;
            this.potencyMultiplier += potionMod.potencyMultiplier - 1.0f;
            this.flatPotencyBonusPositiveEffects += potionMod.flatPotencyBonusPositiveEffects;
            this.flatPotencyBonusNegativeEffects += potionMod.flatPotencyBonusNegativeEffects;
            this.flatDurationBonusPositiveEffects += potionMod.flatDurationBonusPositiveEffects;
            this.flatDurationBonusNegativeEffects += potionMod.flatDurationBonusNegativeEffects;
            this.additionalRandomPositiveEffectCount += potionMod.additionalRandomPositiveEffectCount;
            this.additionalRandomNegativeEffectCount += potionMod.additionalRandomNegativeEffectCount;
            this.chanceToAddLastEffect += potionMod.chanceToAddLastEffect;
            this.lastEffectPotencyMultiplier += potionMod.lastEffectPotencyMultiplier - 1.0f;
            this.lastEffectDurationMultiplier += potionMod.lastEffectDurationMultiplier - 1.0f;
            this.yield += potionMod.yield;
            this.additionalDrinkDurationTicks += potionMod.additionalDrinkDurationTicks;
            this.flags = new PotionFlags(this.flags.makeSplashing | potionMod.flags.makeSplashing, this.flags.makeLingering | potionMod.flags.makeLingering, this.flags.noParticles | potionMod.flags.noParticles, this.flags.unidentifiable | potionMod.flags.unidentifiable, this.flags.makeEffectsPositive | potionMod.flags.makeEffectsPositive, this.flags.potentDecreasingEffect | potionMod.flags.potentDecreasingEffect, this.flags.negateDecreasingDuration | potionMod.flags.negateDecreasingDuration, this.flags.randomColor | potionMod.flags.randomColor, this.flags.incurable | potionMod.flags.incurable, Stream.concat(this.flags.additionalEffects.stream(), potionMod.flags.additionalEffects.stream()).toList());
            return this;
        }

        public Builder potencyMultiplier(float potencyMultiplier) {
            this.potencyMultiplier = potencyMultiplier;
            return this;
        }

        public Builder durationMultiplier(float durationMultiplier) {
            this.durationMultiplier = durationMultiplier;
            return this;
        }

        public PotionMod build() {
            return new PotionMod(this.flatDurationBonusTicks, this.flatPotencyBonus, this.durationMultiplier, this.potencyMultiplier, this.flatPotencyBonusPositiveEffects, this.flatPotencyBonusNegativeEffects, this.flatDurationBonusPositiveEffects, this.flatDurationBonusNegativeEffects, this.additionalRandomPositiveEffectCount, this.additionalRandomNegativeEffectCount, this.chanceToAddLastEffect, this.lastEffectDurationMultiplier, this.lastEffectPotencyMultiplier, this.yield, this.additionalDrinkDurationTicks, this.flags);
        }
    }
}

