/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.potion_workshop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopRecipe;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PotionWorkshopCraftingRecipe
extends PotionWorkshopRecipe {
    protected final IngredientStack baseIngredient;
    protected final boolean consumeBaseIngredient;
    protected final int requiredExperience;
    protected final ItemStack output;

    public PotionWorkshopCraftingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, int craftingTime, int color, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3, IngredientStack baseIngredient, boolean consumeBaseIngredient, int requiredExperience, ItemStack output) {
        super(group, secret, requiredAdvancementIdentifier, craftingTime, color, ingredient1, ingredient2, ingredient3);
        this.output = output;
        this.baseIngredient = baseIngredient;
        this.requiredExperience = requiredExperience;
        this.consumeBaseIngredient = consumeBaseIngredient;
        this.registerInToastManager(this.getType(), this);
    }

    public IngredientStack getBaseIngredient() {
        return this.baseIngredient;
    }

    public boolean consumesBaseIngredient() {
        return this.consumeBaseIngredient;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.POTION_WORKSHOP_CRAFTING_RECIPE_SERIALIZER;
    }

    @Override
    public RecipeType<?> getType() {
        return PastelRecipeTypes.POTION_WORKSHOP_CRAFTING;
    }

    @Override
    public boolean usesReagents() {
        return false;
    }

    @Override
    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public ItemStack assemble(RecipeInput inventory, HolderLookup.Provider drm) {
        return this.output.copy();
    }

    @Override
    public boolean isValidBaseIngredient(ItemStack itemStack) {
        return this.baseIngredient.test(itemStack);
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)IngredientStack.ofItems((Item)PastelItems.MERMAIDS_GEM.get()));
        defaultedList.add((Object)this.baseIngredient);
        this.addIngredientStacks((NonNullList<IngredientStack>)defaultedList);
        return defaultedList;
    }

    @Override
    public boolean matches(@NotNull RecipeInput inv, Level level) {
        if (this.enoughExperienceSupplied(inv, (HolderLookup.Provider)level.registryAccess())) {
            return super.matches(inv, level);
        }
        return false;
    }

    private boolean enoughExperienceSupplied(RecipeInput inv, HolderLookup.Provider lookup) {
        if (this.requiredExperience > 0) {
            for (int i : new int[]{1, 2, 3, 4}) {
                ExperienceHandler storage = (ExperienceHandler)inv.getItem(i).getCapability(PastelCapabilities.Misc.XP, (Object)lookup);
                if (storage == null) continue;
                return storage.extract(this.requiredExperience, true) == this.requiredExperience;
            }
        }
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    @Override
    public int getMinOutputCount(ItemStack itemStack) {
        return 1;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_crafting";
    }

    public static class Serializer
    implements RecipeSerializer<PotionWorkshopCraftingRecipe> {
        public static final MapCodec<PotionWorkshopCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(c -> c.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(c -> c.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(c -> c.requiredAdvancementIdentifier), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(c -> c.craftingTime), (App)Codec.INT.optionalFieldOf("color", (Object)12595288).forGetter(c -> c.color), (App)IngredientStack.CODEC.fieldOf("ingredient1").forGetter(c -> c.ingredient1), (App)IngredientStack.CODEC.optionalFieldOf("ingredient2", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient2), (App)IngredientStack.CODEC.optionalFieldOf("ingredient3", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient3), (App)IngredientStack.CODEC.fieldOf("base_ingredient").forGetter(c -> c.baseIngredient), (App)Codec.BOOL.optionalFieldOf("use_up_base_ingredient", (Object)true).forGetter(c -> c.consumeBaseIngredient), (App)Codec.INT.optionalFieldOf("required_experience", (Object)0).forGetter(c -> c.requiredExperience), (App)ItemStack.CODEC.fieldOf("result").forGetter(c -> c.output)).apply((Applicative)i, PotionWorkshopCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionWorkshopCraftingRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, c -> c.group, ByteBufCodecs.BOOL, c -> c.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, ByteBufCodecs.VAR_INT, c -> c.craftingTime, ByteBufCodecs.VAR_INT, c -> c.color, IngredientStack.STREAM_CODEC, c -> c.ingredient1, IngredientStack.STREAM_CODEC, c -> c.ingredient2, IngredientStack.STREAM_CODEC, c -> c.ingredient3, IngredientStack.STREAM_CODEC, c -> c.baseIngredient, ByteBufCodecs.BOOL, c -> c.consumeBaseIngredient, ByteBufCodecs.VAR_INT, c -> c.requiredExperience, ItemStack.STREAM_CODEC, c -> c.output, PotionWorkshopCraftingRecipe::new);

        public MapCodec<PotionWorkshopCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionWorkshopCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

